% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp.torus.kde.R, R/methods.R
\name{cp.torus.kde}
\alias{cp.torus.kde}
\alias{plot.cp.torus.kde}
\title{Conformal prediction set indices with kernel density estimation}
\usage{
cp.torus.kde(data, eval.point = grid.torus(), level = 0.1, concentration = 25)

\method{plot}{cp.torus.kde}(x, level.id = 1, ...)
}
\arguments{
\item{data}{n x d matrix of toroidal data on \eqn{[0, 2\pi)^d}}

\item{eval.point}{N x N numeric matrix on \eqn{[0, 2\pi)^d}. Default input is
\code{NULL}, which represents the fine grid points on \eqn{[0, 2\pi)^d}.}

\item{level}{either a scalar or a vector, or even \code{NULL}. Default value
is 0.1.}

\item{concentration}{positive number which has the role of \eqn{\kappa} of
von Mises distribution. Default value is 25.}

\item{x}{\code{cp.torus.kde} object}

\item{level.id}{an integer among \code{1:length(cp.torus$level)}.}

\item{...}{additional parameter for ggplot2::ggplot()}
}
\value{
If \code{level} is \code{NULL}, then return kde at \code{eval.point}
  and at data points.

  If \code{level} is a vector, return the above and prediction set indices
  for each value of level.
}
\description{
\code{cp.torus.kde} computes conformal prediction set indices
  (TRUE if in the set) using kernel density estimation as conformity score.
}
\examples{
data <- ILE[1:200, 1:2]
cp.torus.kde(data, eval.point = grid.torus(),
             level = 0.05, concentration = 25)
}
\references{
S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction"
}
\seealso{
\code{\link{kde.torus}}, \code{\link{grid.torus}}
}
