% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lon2Index.R
\name{Lon2Index}
\alias{Lon2Index}
\title{Obtain the index of positions for a region in longitudes}
\usage{
Lon2Index(lon, lonmin, lonmax)
}
\arguments{
\item{lon}{vector of longitudes values.}

\item{lonmin}{a numeric value indicating the minimum longitude of the region 
(understand as the left marging of the region).}

\item{lonmax}{a numeric value indicating the maximum longitude of the region 
(understand as the right mariging of the region).}
}
\value{
the index of positions of all values inside the region in the vector 
lon.
}
\description{
This auxiliary function returns the index of position of a region 
of longitudes in a given vector of longitudes.
}
\examples{

lon <- 1 : 360
pos <- Lon2Index(lon, lonmin = -20, lonmax = 20)
lon[pos]
pos <- Lon2Index(lon, lonmin = 340, lonmax = 20)
lon[pos]
lon <- -180 : 180
pos <- Lon2Index(lon, lonmin = -20, lonmax = 20)
lon[pos]
pos <- Lon2Index(lon, lonmin = 340, lonmax = 20)
lon[pos]

}
