% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDataCM.R
\name{getDataCM}
\alias{getDataCM}
\title{Get ClimMob data}
\usage{
getDataCM(key = NULL, project = NULL, tidynames = FALSE,
  pivot.wider = FALSE, ...)
}
\arguments{
\item{key}{a character for the ClimMob user API key}

\item{project}{a character for the project id}

\item{tidynames}{logical, if TRUE suppress ODK strings}

\item{pivot.wider}{logical, if TRUE return a wider object, each observer is a row}

\item{...}{additional arguments passed to methods}
}
\value{
A data frame with the project data
\item{id}{the participant's package id}
\item{moment}{the data collection moment}
\item{variable}{the variable name}
\item{value}{the value for each variable}
}
\description{
Fetch the trial data from a ClimMob project using an API key
}
\examples{
\dontrun{

# This function will not work without an API key  
# the user API key can be obtained once a free ClimMob account 
# is created via https://climmob.net/climmob3/

my_key <- "add_your_key"
my_project <- "my_climmob_project"

data <- getDataCM(key = my_key, project = my_project)

}

}
\seealso{
\code{\link{getProjectsCM}}
}
