% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineStreamflow.R
\name{combineStreamflow}
\alias{combineStreamflow}
\title{Combines streamflow records to estimate total flows}
\usage{
combineStreamflow(flowlist, mult, approx = FALSE)
}
\arguments{
\item{flowlist}{list of flow data, output of getStreamflow or 
gapfillStreamflow}

\item{mult}{list of multipliers, one for each gage}

\item{approx}{option to interpolate missing values}
}
\value{
total flow for each timestep (as xts)
}
\description{
This function combines streamflow data from multiple gages, averaging records
according to a multiplier list
}
\examples{
gages <- c('05551540', '05552500')
flow <- getStreamflow('2000-01-01', '2010-12-31', gages)
flow <- gapfillStreamflow(flow, list(c(gages[1], gages[2])))
flow <- combineStreamflow(flow, c(0.5, 0.5))
}
