% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sPlotSpectra.R
\name{sPlotSpectra}
\alias{sPlotSpectra}
\title{s-Plot of Spectra Data (Post PCA)}
\usage{
sPlotSpectra(spectra, pca, pc = 1, tol = 0.05, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[=Spectra]{Spectra()}}.}

\item{pca}{The result of a pca calculation on \code{\link{Spectra}} (i.e.
the output from \code{\link{c_pcaSpectra}} or \code{\link{r_pcaSpectra}}).}

\item{pc}{An integer specifying the desired pc plot.}

\item{tol}{A number describing the fraction of points to be labeled. \code{tol = 1.0} labels all the points; \code{tol = 0.05} labels \emph{approximately} the most extreme 5 percent. Set to \code{'none'} to completely suppress labels. Note that a simple approach based upon quantiles is used, assumes that both x and y are each normally distributed, and treats x and y separately.  Thus, this is not a formal treatment of outliers, just a means of labeling points. Groups are lumped together for the computation.}

\item{\dots}{Parameters to be passed to the plotting routines. \emph{Applies to base graphics only}.}
}
\value{
The returned value depends on the graphics option selected (see \code{\link[=GraphicsOptions]{GraphicsOptions()}}).
\itemize{
\item \code{base}: None.  Side effect is a plot.
\item \code{ggplot2}: The plot is displayed, and a \code{ggplot2} object is returned if the value is assigned.  The plot can be modified in the usual \code{ggplot2} manner.
}
}
\description{
Produces a scatter plot of the correlation of the
variables against their covariance for a chosen principal component.  It
allows visual identification of variables driving the separation and thus is
a useful adjunct to traditional loading plots.
}
\examples{

# This example assumes the graphics output is set to ggplot2 (see ?GraphicsOptions).
library("ggplot2")
data(SrE.IR)
pca <- c_pcaSpectra(SrE.IR)
myt <- expression(bolditalic(Serenoa) ~ bolditalic(repens) ~ bold(IR ~ Spectra))
p <- sPlotSpectra(spectra = SrE.IR, pca = pca, pc = 1, tol = 0.001)
p <- p + ggtitle(myt)
p

}
\references{
Wiklund, Johansson, Sjostrom, Mellerowicz, Edlund, Shockcor,
Gottfries, Moritz, and Trygg. "Visualization of GC/TOF-MS-Based
Metabololomics Data for Identification of Biochemically Interesting
Compounds Usings OPLS Class Models" Analytical Chemistry Vol.80 no.1 pgs.
115-122 (2008).
}
\seealso{
Additional documentation at \url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University), Tejasvi Gupta, Matthew J. Keinsley.
}
\keyword{hplot}
