% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mclustSpectra.R
\name{mclustSpectra}
\alias{mclustSpectra}
\title{mclust Analysis of a Spectra Object PCA Results}
\usage{
mclustSpectra(spectra, pca, pcs = c(1:3), dims = c(1, 2), plot = c("BIC",
  "proj", "error"), use.sym = FALSE, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}}.}

\item{pca}{An object of class \code{\link{prcomp}}.}

\item{pcs}{An integer vector describing which PCs to use.}

\item{dims}{A integer vector giving the PCA dimensions to use.}

\item{plot}{A character string indicating what plot to make.  Options are
\code{c("BIC", "proj", "error")}; see \code{Mclust} for details.}

\item{use.sym}{Logical; if true, the color scheme is changed to black and
symbols are used for plotting.}

\item{\dots}{Other parameters to be passed downstream.}
}
\value{
The \code{Mclust} model is returned invisibly, and a plot is made.
}
\description{
This function is a wrapper for the \code{Mclust} function and associated
plotting functions.
}
\examples{

require("mclust")
data(SrE.IR)
class <- c_pcaSpectra(SrE.IR, choice = "autoscale")
mclustSpectra(SrE.IR, class, main = "Cuticle IR", plot = "BIC")
mclustSpectra(SrE.IR, class, main = "Cuticle IR", plot = "proj")
mclustSpectra(SrE.IR, class, main = "Cuticle IR", plot = "error",
	 truth = metMUD1$groups)

}
\references{
\url{https://github.com/bryanhanson/ChemoSpec}
}
\seealso{
\code{\link[mclust]{Mclust}} for background on the method.
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{cluster}
\keyword{multivariate}
