% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NlmeParallelHost.R
\docType{class}
\name{NlmeParallelHost-class}
\alias{NlmeParallelHost-class}
\alias{NlmeParallelHost}
\title{Class initializer for NlmeParallelHost}
\description{
NLME Parallel Host object class. Class represents an NLME parallel host which
can either be local or remote.
}
\section{Slots}{

\describe{
\item{\code{sharedDirectory}}{Directory in which the run happens. If it is
given as UNC path on Windows, a PS Drive will be mapped within powershell
command to any free Disk letter on local machine where execution performed
(not applicable to remote executions). After execution PS Drive will be
removed. A warning will be given if removal is unsuccessful.}

\item{\code{installationDirectory}}{Directory containing NLME libraries/scripts}

\item{\code{hostName}}{Visual name of the host(default local)}

\item{\code{machineName}}{IP address or name of the host(default local)}

\item{\code{hostType}}{\code{windows} or \code{linux}. For remote runs it is possible to point
the distro suppported, i.e. \code{RHEL8} or \code{UBUNTU2204}. In such case the
corresponding \code{PML_BIN_DIR} variable will be created and NLME Engine libraries
will be looked in \verb{installationDirectory/\{$PML_BIN_DIR\}}.}

\item{\code{numCores}}{Number of compute cores}

\item{\code{isLocal}}{Is this a local \code{TRUE} or remote \code{FALSE} host?}

\item{\code{rLocation}}{Path to Rscript executable on remote host;
ignored on local host}

\item{\code{scriptPath}}{a path to the script to be executed before
starting Rscript within Certara.NLME8 package on the remote host. Ignored
when running locally.}

\item{\code{userAuthentication}}{User credential for remote system. See
\code{\link[=NlmeUserAuthentication]{NlmeUserAuthentication()}}}

\item{\code{parallelMethod}}{Options are:
\verb{None|Multicore|LOCAL_MPI|SGE|SGE_MPI|TORQUE|}
\code{TORQUE_MPI|LSF|LSF_MPI|SLURM|SLURM_MPI}. Supply argument using
\code{NlmeParallelMethod("LOCAL_MPI")} for example.}
}}

\examples{
host <- hostParams(
  parallelMethod = "LOCAL_MPI",
  hostName = "local_mpi",
  numCores = 4
)

}
\keyword{NLME}
\keyword{NlmeParallelHost}
\keyword{internal}
