% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_Dosepoint.R
\name{modify_Dosepoint}
\alias{modify_Dosepoint}
\title{Modify Dosepoint in PML models}
\usage{
modify_Dosepoint(
  PMLParametersSets,
  DosepointName,
  tlag,
  bioavail,
  duration,
  rate,
  PMLStructures = NULL
)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{DosepointName}{A character string giving the name of the Dosepoint.}

\item{tlag}{An optional structural parameter giving the time lag for the
doses coming into current Dosepoint.}

\item{bioavail}{An optional structural parameter giving the bioavailability
of the doses coming into current Dosepoint.}

\item{duration}{An optional structural parameter giving the duration of
infusion for the doses coming into current Dosepoint.}

\item{rate}{An optional structural parameter giving the rate of infusion for
the doses coming into current Dosepoint.}

\item{PMLStructures}{Character or character vector specifying names of PML
structures in which the dosepoint statement will be modified. For the
naming convention of PMLStructures, see Details section of
\code{\link[=get_PMLParametersSets]{get_PMLParametersSets()}}.}
}
\value{
An updated list of PML models (\code{PMLModels} class instance) matching
the specified options.
}
\description{
Modify Dosepoint in PML models
}
\details{
This function can only be used to modify the structural parameters
in the built-in models (i.e., created using either \code{create_ModelEmax()} or
\code{create_ModelPK()}).
}
\examples{
PMLParametersSets <-
  get_PMLParametersSets(CompartmentsNumber = c(1, 2, 3))
# update structural paramter type
PMLParametersSetsVMod <-
 modify_Dosepoint(PMLParametersSets,
            DosepointName = "A1",
            tlag = StParm(StParmName = "Tlag",
                          State = "Searched"))

}
\seealso{
\code{\link[=list_Dosepoints]{list_Dosepoints()}}

Functions used for Dosepoint specification: 
\code{\link{Dosepoint}()},
\code{\link{create_ModelPK}()}
}
\concept{Dosepoints}
