% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObservationCustomClass.R
\name{ObservationCustom}
\alias{ObservationCustom}
\title{Create an instance of custom Observation class.}
\usage{
ObservationCustom(
  ObservationName = "CObs",
  Type = "observe",
  Statement = "",
  StatementNames = list(),
  Sigma = list(),
  Dobefore = c(),
  Doafter = c(),
  BQL = FALSE,
  BQLValue = NA,
  PMLStructure = character()
)
}
\arguments{
\item{ObservationName}{A character string giving the name of the Observation.}

\item{Type}{One of the following: \code{observe}, \code{multi}, \code{LL}, \code{event}, \code{count}, \code{ordinal}}

\item{Statement}{A character string giving the RHS of response statement without \code{Type}.}

\item{StatementNames}{A character vector giving the names of variables used in the \code{Statement}.}

\item{Sigma}{a list specifying the chosen sigma value Should be given only if
\code{Type == "observe"}}

\item{Dobefore}{A character string specifying the sequence of operations to
be performed before current observation event.}

\item{Doafter}{A character string specifying the sequence of operations to
be performed after current observation event.}

\item{BQL}{A logical value indicating whether the dataset contains BQL values
and they should be taken into account (M3 method).}

\item{BQLValue}{An optional numeric positive value of static LLOQ. Applicable
only when BQL argument is \code{TRUE}. Any observed value less than or equal to
that LLOQ value is treated as censored.}

\item{PMLStructure}{Character specifying the name of PML structure in which
the observation should be added. For the naming convention of
PMLStructures, see Details section of \code{\link[=create_ModelPK]{create_ModelPK()}}.}
}
\value{
A new Observation object
}
\description{
This function creates a new instance of custom Observation object and validates it.
All PML responses are supported (\code{observe}, \code{multi}, \code{LL}, \code{event}, \code{count}, \code{ordinal})
}
\seealso{
Functions used for Observation specification: 
\code{\link{Observation}()},
\code{\link{Sigmas}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_Observation}()},
\code{\link{remove_Observation}()}
}
\concept{Observations}
