% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode.solver.R
\name{ode.solver}
\alias{ode.solver}
\title{ode.solver}
\usage{
ode.solver(time_vec, initial_value, times, X, model, target, coefs,
  smooth.type = "smoothing.spline", reltol = 10^(-10),
  abstol = 10^(-16))
}
\arguments{
\item{time_vec}{numeric vector. Specifices the points at which to
evaluate the target trajectory.}

\item{initial_value}{numeric value. Specifies the value of the
target at initial time point.}

\item{times}{numeric vector of length L. Specifices the time
points at which the predictors where observed.}

\item{X}{predictor matrix of dimension L x d. Each column
corresponds to a different predictor observed at the time points
\code{times}.}

\item{model}{list of mass-action terms. Each element in the list
consists of a vector of predictor variables which are multiplied
to a single term in the mass-action equation.}

\item{target}{integer specifing which variable is the target.}

\item{coefs}{numeric vector. Specifies the parameter values for
each term in \code{model}.}

\item{smooth.type}{string. Specifies which type of smoothing to
use. The following options exist: "smoothing.spline", "loess",
"linear", "constant".}

\item{reltol}{numeric. Relative tolarance used in CVODE.}

\item{abstol}{numeric. Absolute tolarance used in CVODE.}
}
\value{
object returned by CVODE.
}
\description{
Solves a mass-action ODE for a target variable Y by using smooth
approximations of the predictor variables X.
}
\details{
For further details see the references.
}
\examples{

## Generate data from Maillard reaction
simulation.obj <- generate.data.maillard(target=11,
                                         env=rep(1:5, each=5),
                                         L=20,
                                         par.noise=list(noise.sd=0.1,
                                                        only.target.noise=FALSE,
                                                        relativ=TRUE))
D <- simulation.obj$simulated.data
time <- simulation.obj$time

## Solve for Melanoidin
X <- do.call(cbind, split(as.vector(t(D[1:5,])), rep(1:11, each=length(unique(time)))))
times <- rep(unique(time), 5)
odefit <- ode.solver(time, 0, times, X, list(c(8)), 11, 0.12514)
plot(odefit[,1], odefit[,2], type="l")
points(times, X[,11])
}
\references{
Pfister, N., S. Bauer, J. Peters (2018).
Identifying Causal Structure in Large-Scale Kinetic Systems
ArXiv e-prints (arXiv:1810.11776).
}
\author{
Niklas Pfister, Stefan Bauer and Jonas Peters
}
