% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_SaveExp.R
\name{SaveExp}
\alias{SaveExp}
\title{Save an experiment in a format compatible with CST_Load}
\usage{
SaveExp(
  data,
  lon,
  lat,
  Dataset,
  var_name,
  units,
  startdates,
  Dates,
  cdo_grid_name,
  projection,
  destination,
  extra_string = NULL
)
}
\arguments{
\item{data}{an multi-dimensional array with named dimensions (longitude, latitude, time, member, sdate)}

\item{lon}{vector of logitud corresponding to the longitudinal dimension in data}

\item{lat}{vector of latitud corresponding to the latitudinal dimension in data}

\item{Dataset}{a vector of character string indicating the names of the datasets}

\item{var_name}{a character string indicating the name of the variable to be saved}

\item{units}{a character string indicating the units of the variable}

\item{startdates}{a vector of dates indicating the initialization date of each simulations}

\item{Dates}{a matrix of dates with two dimension 'time' and 'sdate'.}

\item{cdo_grid_name}{a character string indicating the name of the grid e.g.: 'r360x181'}

\item{projection}{a character string indicating the projection name}

\item{destination}{a character string indicating the path where to store the NetCDF files}

\item{extra_string}{a character string to be include as part of the file name, for instance, to identify member or realization.}
}
\value{
the function creates as many files as sdates per dataset. Each file could contain multiple members. It would be added to the file name between underscore characters.
The path will be created with the name of the variable and each Datasets.
}
\description{
This function is created for compatibility with CST_Load/Load for saving post-processed datasets such as those calibrated of downscaled with CSTools functions
}
\examples{
\dontrun{
data <- lonlat_temp$exp$data
lon <- lonlat_temp$exp$lon
lat <- lonlat_temp$exp$lat
Dataset <- 'XXX'
var_name <- 'tas'
units <- 'k'
startdates <- lapply(1:length(lonlat_temp$exp$Datasets),
                    function(x) {
                        lonlat_temp$exp$Datasets[[x]]$InitializationDates[[1]]})[[1]]
Dates <- lonlat_temp$exp$Dates$start
dim(Dates) <- c(time = length(Dates)/length(startdates), sdate = length(startdates))
cdo_grid_name = attr(lonlat_temp$exp$lon, 'cdo_grid_name')
projection = attr(lonlat_temp$exp$lon, 'projection')
destination = './path/'
SaveExp(data, lon, lat, Dataset, var_name, units, startdates, Dates,
                   cdo_grid_name, projection, destination)
}
}
\author{
Perez-Zanon Nuria, \email{nuria.perez@bsc.es}
}
