% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_Anomaly.R
\name{CST_Anomaly}
\alias{CST_Anomaly}
\title{Anomalies relative to a climatology along selected dimension with or without cross-validation}
\usage{
CST_Anomaly(exp = NULL, obs = NULL, cross = FALSE, memb = TRUE,
  dim_anom = 3)
}
\arguments{
\item{exp}{an object of class \code{s2dv_cube} as returned by \code{CST_Load} function, containing the seasonal forecast experiment data in the element named \code{$data}.}

\item{obs}{an object of class \code{s2dv_cube} as returned by \code{CST_Load} function, containing the observed data in the element named \code{$data}.'}

\item{cross}{A logical value indicating whether cross-validation should be applied or not. Default = FALSE.}

\item{memb}{A logical value indicating whether Clim() computes one climatology for each experimental data 
product member(TRUE) or it computes one sole climatology for all members (FALSE). Default = TRUE.}

\item{dim_anom}{An integer indicating the dimension along which the climatology will be computed. It 
usually corresponds to 3 (sdates) or 4 (ftime). Default = 3.}
}
\value{
A list with two S3 objects, 'exp' and 'obs', of the class 's2dv_cube', containing experimental and date-corresponding observational anomalies, respectively. These 's2dv_cube's can be ingested by other functions in CSTools.
}
\description{
This function computes the anomalies relative to a climatology computed along the 
selected dimension (usually starting dates or forecast time) allowing the application or not of
crossvalidated climatologies. The computation is carried out independently for experimental and 
observational data products.
}
\examples{
# Example 1:
mod <- 1 : (2 * 3 * 4 * 5 * 6 * 7)
dim(mod) <- c(dataset = 2, member = 3, sdate = 4, ftime = 5, lat = 6, lon = 7)
obs <- 1 : (1 * 1 * 4 * 5 * 6 * 7)
dim(obs) <- c(dataset = 1, member = 1, sdate = 4, ftime = 5, lat = 6, lon = 7)
lon <- seq(0, 30, 5)
lat <- seq(0, 25, 5)
exp <- list(data = mod, lat = lat, lon = lon)
obs <- list(data = obs, lat = lat, lon = lon)
attr(exp, 'class') <- 's2dv_cube'
attr(obs, 'class') <- 's2dv_cube'

anom1 <- CST_Anomaly(exp = exp, obs = obs, cross = FALSE, memb = TRUE)
str(anom1)
anom2 <- CST_Anomaly(exp = exp, obs = obs, cross = TRUE, memb = TRUE)
str(anom2)

anom3 <- CST_Anomaly(exp = exp, obs = obs, cross = TRUE, memb = FALSE)
str(anom3)

anom4 <- CST_Anomaly(exp = exp, obs = obs, cross = FALSE, memb = FALSE)
str(anom4)

}
\author{
Perez-Zanon Nuria, \email{nuria.perez@bsc.es}

Pena Jesus, \email{jesus.pena@bsc.es}
}
\seealso{
\code{\link[s2dverification]{Ano_CrossValid}}, \code{\link[s2dverification]{Clim}} and \code{\link{CST_Load}}
}

