% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindCapacityFactor.R
\name{WindCapacityFactor}
\alias{WindCapacityFactor}
\title{Wind capacity factor}
\usage{
WindCapacityFactor(
  wind,
  IEC_class = c("I", "I/II", "II", "II/III", "III"),
  dates = NULL,
  start = NULL,
  end = NULL,
  time_dim = "time",
  ncores = NULL
)
}
\arguments{
\item{wind}{a multidimensional array, vector or scalar with instantaneous wind speeds expressed in m/s.}

\item{IEC_class}{a string indicating the IEC wind class (see IEC 61400-1) of the turbine to be selected. Classes \code{'I'}, \code{'II'} and \code{'III'} are suitable for sites with an annual mean wind speed of 10, 8.5 and 7.5 m/s respectively. Classes \code{'I/II'} and \code{'II/III'} indicate intermediate turbines that fit both classes. More details of the five turbines and a plot of its power curves can be found in Lledó et al. (2019).}

\item{dates}{a vector of dates or a multidimensional array of dates with named dimensions matching the dimensions on parameter 'data'. By default it is NULL, to select a period this parameter must be provided.}

\item{start}{an optional parameter to defined the initial date of the period to select from the data by providing a list of two elements: the initial date of the period and the initial month of the period. By default it is set to NULL and the indicator is computed using all the data provided in \code{data}.}

\item{end}{an optional parameter to defined the final date of the period to select from the data by providing a list of two elements: the final day of the period and the final month of the period. By default it is set to NULL and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{a character string indicating the name of the function to compute the indicator. By default, it is set to 'ftime'. More than one dimension name matching the dimensions provided in the object \code{data$data} can be specified.}

\item{ncores}{an integer indicating the number of cores to use in parallel computation for temporal subsetting.}
}
\value{
An array with the same dimensions as wind, containing the Wind Capacity Factor (unitless).
}
\description{
Wind capacity factor computes the wind power generated by a specific wind turbine model under specific wind speed conditions, and expresses it as a fraction of the rated capacity (i.e. maximum power) of the turbine.

It is computed by means of a tabular power curve that relates wind speed to power output. The tabular values are interpolated with a linear piecewise approximating function to obtain a smooth power curve. Five different power curves that span different IEC classes can be selected (see below).
}
\examples{
wind <- rweibull(n = 100, shape = 2, scale = 6)
WCF <- WindCapacityFactor(wind, IEC_class = "III")

}
\references{
Lledó, Ll., Torralba, V., Soret, A., Ramon, J., & Doblas-Reyes, F. J. (2019). Seasonal forecasts of wind power generation. Renewable Energy, 143, 91–100. https://doi.org/10.1016/j.renene.2019.04.135

International Standard IEC 61400-1 (third ed.) (2005)
}
\author{
Llorenç Lledó, \email{llledo@bsc.es}
}
