% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{get_opt_weights}
\alias{get_opt_weights}
\title{Weight optimisation}
\usage{
get_opt_weights(
  coin,
  itarg = NULL,
  dset,
  Level,
  cortype = "pearson",
  optype = "balance",
  toler = NULL,
  maxiter = NULL,
  weights_to = NULL,
  out2 = "list"
)
}
\arguments{
\item{coin}{coin object}

\item{itarg}{a vector of (relative) target importances. For example, \code{c(1,2,1)} would specify that the second
indicator should be twice as "important" as the other two.}

\item{dset}{Name of the aggregated data set found in \code{coin$Data} which results from calling \code{\link[=Aggregate]{Aggregate()}}.}

\item{Level}{The aggregation level to apply the weight adjustment to. This can only be one level.}

\item{cortype}{The type of correlation to use - can be either \code{"pearson"}, \code{"spearman"} or \code{"kendall"}. See \link[stats:cor]{stats::cor}.}

\item{optype}{The optimisation type. Either \code{"balance"}, which aims to balance correlations
according to a vector of "importances" specified by \code{itarg} (default), or \code{"infomax"} which aims to maximise
overall correlations.}

\item{toler}{Tolerance for convergence. Defaults to 0.1 (decrease for more accuracy, increase if convergence problems).}

\item{maxiter}{Maximum number of iterations. Default 500.}

\item{weights_to}{Name to write the optimised weight set to, if \code{out2 = "coin"}.}

\item{out2}{Where to output the results. If \code{"coin"} (default for coin input), appends to updated coin,
creating a new list of weights in \code{.$Parameters$Weights}. Otherwise if \code{"list"} outputs to a list (default).}
}
\value{
If \code{out2 = "coin"} returns an updated coin object with a new set of weights in \code{.$Meta$Weights}, plus
details of the optimisation in \code{.$Analysis}.
Else if \code{out2 = "list"} the same outputs (new weights plus details of optimisation) are wrapped in a list.
}
\description{
This function provides optimised weights to agree with a pre-specified vector of "target importances".
}
\details{
This is a linear version of the weight optimisation proposed in this paper: \doi{10.1016/j.ecolind.2017.03.056}.
Weights are optimised to agree with a pre-specified vector of "importances". The optimised weights are returned back to the coin.

See \code{vignette("weights")} for more details on the usage of this function and an explanation of the underlying
method.

This function replaces the now-defunct \code{weightOpt()} from COINr < v1.0.
}
\examples{
# build example coin
coin <- build_example_coin(quietly = TRUE)

# check correlations between level 3 and index
get_corr(coin, dset = "Aggregated", Levels = c(3, 4))

# optimise weights at level 3
l_opt <- get_opt_weights(coin, itarg = "equal", dset = "Aggregated",
                        Level = 3, weights_to = "OptLev3", out2 = "list")

# view results
tail(l_opt$WeightsOpt)

l_opt$CorrResultsNorm

}
