% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_lv_switchgear_and_other.R
\name{financial_cof_lv_switchgear_and_other}
\alias{financial_cof_lv_switchgear_and_other}
\title{Financial cost of Failure for LV swicthgear and others}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
financial_cof_lv_switchgear_and_other(
  lv_asset_category,
  type_financial_factor_criteria,
  access_factor_criteria
)
}
\arguments{
\item{lv_asset_category}{String The type of LV asset category
Options: \code{lv_asset_category = c("LV Board (WM)",
"LV Board (X-type Network) (WM)", "LV Circuit Breaker",
"LV Pillar (ID)", "LV Pillar (OD at Substation)", "LV Pillar (OD not at a Substation)")}}

\item{type_financial_factor_criteria}{String Type Financial factor criteria for LV switchgear
(cf. section D1.2.1, page 178, CNAIM, 2021).
Options: \code{type_financial_factor_criteria = c("Non Asbestos clad",
"Asbestos clad")}}

\item{access_factor_criteria}{String. Asses Financial factor criteria for LV switchgear
setting (cf. table 221, page 180, CNAIM, 2021).
Options: \code{access_factor_criteria = c("Type A", "Type B", "Type C")}.}
}
\value{
Numeric. Financial consequences of failure for LV switchgear
}
\description{
This function calculates financial consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Financial consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
financial_cof_lv_switchgear_and_other(lv_asset_category = "LV Board (WM)",
type_financial_factor_criteria = "Asbestos clad",
access_factor_criteria = "Type A")
}
