% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_lv_switchgear_and_other.R
\name{pof_lv_switchgear_and_other}
\alias{pof_lv_switchgear_and_other}
\title{Current Probability of Failure for LV switchgear and others}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
pof_lv_switchgear_and_other(
  lv_asset_category = "LV Circuit Breaker",
  placement = "Default",
  altitude_m = "Default",
  distance_from_coast_km = "Default",
  corrosion_category_index = "Default",
  age,
  measured_condition_inputs,
  observed_condition_inputs,
  reliability_factor = "Default"
)
}
\arguments{
\item{lv_asset_category}{String The type of LV asset category}

\item{placement}{String. Specify if the asset is located outdoor or indoor.}

\item{altitude_m}{Numeric. Specify the altitude location for
the asset measured in meters from sea level.\code{altitude_m}
is used to derive the altitude factor. See page 111,
table 23 in CNAIM (2021). A setting of \code{"Default"}
will set the altitude factor to 1 independent of \code{asset_type}.}

\item{distance_from_coast_km}{Numeric. Specify the distance from the
coast measured in kilometers. \code{distance_from_coast_km} is used
to derive the distance from coast factor See page 110,
table 22 in CNAIM (2021). A setting of \code{"Default"} will set the
 distance from coast factor to 1 independent of \code{asset_type}.}

\item{corrosion_category_index}{Integer.
Specify the corrosion index category, 1-5.}

\item{age}{Numeric. The current age in years of the conductor.}

\item{measured_condition_inputs}{Named list observed_conditions_input}

\item{observed_condition_inputs}{Named list observed_conditions_input
\code{conductor_samp = c("Low","Medium/Normal","High","Default")}.
See page 161, table 199 and 201 in CNAIM (2021).}

\item{reliability_factor}{Numeric. \code{reliability_factor}
shall have a value between 0.6 and 1.5. A setting of \code{"Default"}
 sets the \code{reliability_factor} to 1.
See section 6.14 on page 73 in CNAIM (2021).}
}
\value{
DataFrame Current probability of failure
per annum per kilometer along with current health score.
}
\description{
This function calculates the current
annual probability of failure for LV switchgear and others
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function. For more information about the
probability of failure function see section 6
on page 34 in CNAIM (2021).
}
\examples{
# Current annual probability of failure for LV Switchgear and other
pof_lv_switchgear_and_other(
lv_asset_category = "LV Circuit Breaker",
placement = "Default",
altitude_m = "Default",
distance_from_coast_km = "Default",
corrosion_category_index = "Default",
age = 10,
observed_condition_inputs =
list("external_condition" =
list("Condition Criteria: Observed Condition" = "Default")),
measured_condition_inputs =
list("operational_adequacy" =
list("Condition Criteria: Operational Adequacy" = "Default")),
reliability_factor = "Default")
}
