% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_future_cables_66_33kv.R
\name{pof_future_cables_66_33kv}
\alias{pof_future_cables_66_33kv}
\title{Future Probability of Failure for 33-66kV cables}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
pof_future_cables_66_33kv(
  cable_type = "66kV UG Cable (Gas)",
  sub_division = "Aluminium sheath - Aluminium conductor",
  utilisation_pct = "Default",
  operating_voltage_pct = "Default",
  sheath_test = "Default",
  partial_discharge = "Default",
  fault_hist = "Default",
  leakage = "Default",
  reliability_factor = "Default",
  age,
  simulation_end_year = 100
)
}
\arguments{
\item{cable_type}{String.
A sting that refers to the specific asset category.
See See page 15, table 1 in CNAIM (2017).
Options:
\code{cable_type = c("33kV UG Cable (Gas)", "66kV UG Cable (Gas)",
"33kV UG Cable (Non Pressurised)", "66kV UG Cable (Non Pressurised)",
"33kV UG Cable (Oil)", "66kV UG Cable (Oil)")
}. The default setting is
\code{cable_type = "66kV UG Cable (Gas)"}.}

\item{sub_division}{String. Refers to material the sheath and conductor is
made of. Options:
\code{sub_division = c("Aluminium sheath - Aluminium conductor",
"Aluminium sheath - Copper conductor",
"Lead sheath - Aluminium conductor", "Lead sheath - Copper conductor")
}}

\item{utilisation_pct}{Numeric. The max percentage of utilisation
under normal operating conditions.}

\item{operating_voltage_pct}{Numeric. The ratio in percent of
operating/design voltage.}

\item{sheath_test}{String. Only applied for non pressurised cables.
Indicating the state of the sheath. Options:
\code{sheath_test = c("Pass", "Failed Minor", "Failed Major",
"Default")}. See page 141, table 168 in CNAIM (2017).}

\item{partial_discharge}{String. Only applied for non pressurised cables.
Indicating the level of partial discharge. Options:
\code{partial_discharge = c("Low", "Medium", "High",
 "Default")}. See page 141, table 169 in CNAIM (2017).}

\item{fault_hist}{Numeric. Only applied for non pressurised cables.
The calculated fault rate for the cable in the period per kilometer.
A setting of \code{"No historic faults recorded"}
indicates no fault. See page 141, table 170 in CNAIM (2017).}

\item{leakage}{String. Only applied for oil and gas pressurised cables.
Options:
\code{leakage = c("No (or very low) historic leakage recorded",
"Low/ moderate", "High", "Very High", "Default")}.
See page 142, table 171 (oil) and 172 (gas) in CNAIM (2017).}

\item{reliability_factor}{Numeric. \code{reliability_factor}
shall have a value between 0.6 and 1.5. A setting of \code{"Default"}
 sets the \code{reliability_factor} to 1.
See section 6.14 on page 69 in CNAIM (2017).}

\item{age}{Numeric. The current age in years of the cable.}

\item{simulation_end_year}{Numeric. The last year of simulating probability
of failure. Default is 100.}
}
\value{
Numeric array. Future probability of failure
per annum per kilometre for 33-66kV cables.
}
\description{
This function calculates the future
annual probability of failure per kilometer for a 33-66kV cables.
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function. For more information about the
probability of failure function see section 6
on page 30 in CNAIM (2017).
}
\examples{
# Future probability of failure for 66kV UG Cable (Non Pressurised)
pof_66kV_non_pressurised <-
pof_future_cables_66_33kv(cable_type = "66kV UG Cable (Non Pressurised)",
sub_division = "Aluminium sheath - Aluminium conductor",
utilisation_pct = 75,
operating_voltage_pct = 50,
sheath_test = "Default",
partial_discharge = "Default",
fault_hist = "Default",
leakage = "Default",
reliability_factor = "Default",
age = 1,
simulation_end_year = 100)
# Plot
plot(pof_66kV_non_pressurised$PoF * 100,
type = "line", ylab = "\%", xlab = "years",
main = "PoF per kilometre - 66kV UG Cable (Non Pressurised)")
}
