% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_friedman.R
\name{friedman}
\alias{friedman}
\title{Friedman Test}
\usage{
friedman(y, groups, blocks, components = FALSE)
}
\arguments{
\item{y}{a numeric vector for the response variable.}

\item{groups}{a vector giving the group for the corresponding elements of
\code{y}.}

\item{blocks}{a vector giving the block for the corresponding elements of
\code{y}.}

\item{components}{a TRUE or FALSE flag to indicate if chi-squared or F
orthogonal component p-values are wanted.}
}
\value{
The Friedman test results statistic adjusted for ties together with the
associated p-value.
}
\description{
\code{friedman} returns the test statistic and p-value for the Friedman test.
}
\examples{
attach(jam)
friedman(y = sweetness_ranks, groups = type, blocks = judge,
components = TRUE)
}
\references{
Rayner, J.C.W and Livingston, G. C. (2022). An Introduction to Cochran-Mantel-Haenszel Testing and Nonparametric ANOVA. Wiley.
}
