% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_CMH.R
\name{CMH}
\alias{CMH}
\title{CMH Test}
\usage{
CMH(
  treatment,
  response,
  strata = NULL,
  a_ij = NULL,
  b_hj = NULL,
  test_OPA = TRUE,
  test_GA = TRUE,
  test_MS = TRUE,
  test_C = TRUE,
  cor_breakdown = TRUE
)
}
\arguments{
\item{treatment}{a factor vector representing the treatment applied.}

\item{response}{a factor vector giving the response category for the
corresponding elements of \code{treatment}.}

\item{strata}{a factor vector giving the strata or block for the
corresponding elements of \code{treatment} and \code{response}.}

\item{a_ij}{a t x b matrix of treatment scores. The matrix allows for
different scores to be used over different strata. If a t x 1 vector of
scores is provided, it is assumed that the scores are the same across strata
and a warning provided.}

\item{b_hj}{a c x b matrix of response scores. The matrix allows for
different scores to be used over different strata. If a c x 1 vector of
scores is provided, it is assumed that the scores are the same across strata
and a warning provided.}

\item{test_OPA}{TRUE or FALSE flag to include the calculation of the OPA
test values.}

\item{test_GA}{TRUE or FALSE flag to include the calculation of the GA
test values.}

\item{test_MS}{TRUE or FALSE flag to include the calculation of the MS
test values. If response scores are not included, this test will not be
performed.}

\item{test_C}{TRUE or FALSE flag to include the calculation of the C
test values. If response scores and treatment scores are not included, this
test will not be performed.}

\item{cor_breakdown}{TRUE or FALSE flag to indicate if a correlation
breakdown over the strata is required.}
}
\value{
The CMH test results for the four tests assuming the required
information is supplied.
}
\description{
\code{CMH} returns the test statistics and p-values for the four CMH tests.
}
\details{
Provided the required information is used in the function, the function will
return all four CMH test results.
}
\examples{
CMH(treatment = marriage$religion, response = marriage$opinion,
strata = marriage$education, test_OPA = FALSE, test_MS = FALSE)
}
\references{
Rayner, J.C.W and Livingston, G. C. (2022). An Introduction to Cochran-Mantel-Haenszel Testing and Nonparametric ANOVA. Wiley.
}
