% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{tsne.centralities}
\alias{tsne.centralities}
\title{t-Distributed Stochastic Neighbor Embedding (t-SNE) on centrality measures}
\usage{
tsne.centralities(x, dims = 2, perplexity = 5, scale = TRUE)
}
\arguments{
\item{x}{a list containg the computed cetrality values}

\item{dims}{integer; number of the outpu dimensions(default=2)}

\item{perplexity}{numeric; A flexible measure of the efficient number of neighbors.
The performance of SNE is fairly robust to changes in the perplexity, and typical
values are between 5 and 50.(default=5)}

\item{scale}{Whether the centrality values should be scaled or not(default=TRUE)}
}
\value{
It resturns cost plot of tsne results which displays centralities in order of their corresponding costs.
}
\description{
This function applies t-SNE, dimensionality reduction algorithm, on
centrality measures.
}
\details{
t-SNE is a non-linear dimensionality reduction algorithm used for exploring high-dimensional data. Here, It maps multi-dimensional centrality measure data to less dimensions suitable to work with it.
}
\references{
van der Maaten, L. (2014). Accelerating t SNE using Tree Based Algorithms. Journal of Machine Learning Research, 15, 3221–3245.
Van Der Maaten, L. J. P., & Hinton, G. E. (2008). Visualizing high dimensional data using t sne. Journal of Machine Learning Research, 9, 2579–2605.
}
\seealso{
\code{\link[Rtsne]{Rtsne}}
}
\author{
Minoo Ashtiani, Mohieddin Jafari
}
