% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen.R
\name{data_gen}
\alias{data_gen}
\title{Data generation function}
\usage{
data_gen(n, scenario, ratio, overlap, all_confounder)
}
\arguments{
\item{n}{total number of units for simulation}

\item{scenario}{simulation scenario 1 or scenario 2}

\item{ratio}{ratio of units in the treatment groups}

\item{overlap}{levels of covariate overlap: Please select: weak, strong, moderate}

\item{all_confounder}{TRUE or FALSE. overlap is lacking for a variable that is not predictive of the outcome (all_confounder equals to TRUE) or situations when it is lacking for a true confounder (all_confounder equals to FALSE)}
}
\value{
list with the 5 elements. Nested within each list, it contains
\item{n:}{Number of units for simulation}
\item{trt_ind:}{A data frame with number of rows equals to n and 11 columns}
\item{Y:}{Observed binary outcome for 3 treatments}
\item{Yobs:}{Observed binary outcome}
\item{Est:}{True ATE/ATT for RD/RR/OR}
}
\description{
This function generates data to test different causal inference methods.
}
\examples{
library(CIMTx)
set.seed(3242019)
idata = data_gen(n = 120, ratio =1,scenario = 1)
}
