% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/permutationBenchmarkFunctions.R
\name{benchmarkGeneratorTSP}
\alias{benchmarkGeneratorTSP}
\title{Create (Asymmetric) Travelling Salesperson Problem (TSP) Benchmark}
\usage{
benchmarkGeneratorTSP(distanceMatrix, type = "Cycle")
}
\arguments{
\item{distanceMatrix}{Matrix that collects the distances between travelled locations.}

\item{type}{Can be "Cycle" (return to start, default) or "Path" (no return to start).}
}
\value{
the function of type cost=f(permutation)
}
\description{
Creates a benchmark function for the (Asymmetric) Travelling Salesperson Problem.
Path (Do not return to start of tour. Start and end of tour not fixed.)
or Cycle (Return to start of tour). Symmetry depends on supplied distance matrix.
}
\examples{
set.seed(1)
#create 5 random locations to be part of a tour
n=5
cities <- matrix(runif(2*n),,2)
#calculate distances between cities
cdist <- as.matrix(dist(cities))
#create objective functions (for path or cycle)
fun1 <- benchmarkGeneratorTSP(cdist, "Path")
fun2 <- benchmarkGeneratorTSP(cdist, "Cycle")
#evaluate
fun1(1:n)
fun1(n:1)
fun2(n:1)
fun2(1:n)
}
\seealso{
\code{\link{benchmarkGeneratorQAP}}, \code{\link{benchmarkGeneratorFSP}}, \code{\link{benchmarkGeneratorWT}}
}

