% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{initialize_patients}
\alias{initialize_patients}
\title{Initialize Patient List}
\usage{
initialize_patients(uri_fun, user, password, host, port, database)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}
}
\value{
{
Confirmation that requested operation was completed, or error message if attempt failed.
}
}
\description{
All patient-specific information is deleted, including clinical event dates. Original notes and NLP annotations are preserved.
}
\examples{
\dontrun{
initialize_patients(uri_fun = mongo_uri_standard, user = 'John', password = 'db_password_1234',
host = 'server1234', port = NA, database = 'TEST_PROJECT')
}
}
