% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdmSubset.R
\name{cdmSample}
\alias{cdmSample}
\alias{cdm_sample}
\title{Subset a cdm object to a random sample of individuals}
\usage{
cdmSample(cdm, n, seed = sample.int(1e+06, 1), name = "person_sample")

cdm_sample(cdm, n, seed = sample.int(1e+06, 1), name = "person_sample")
}
\arguments{
\item{cdm}{A cdm_reference object.}

\item{n}{Number of persons to include in the cdm.}

\item{seed}{Seed for the random number generator.}

\item{name}{Name of the table that will contain the sample of persons.}
}
\value{
A modified cdm_reference object where all clinical tables are lazy
queries pointing to subset
}
\description{
\code{cdmSample} takes a cdm object and returns a new cdm that includes only a
random sample of persons in the cdm. Only \code{person_id}s in both the person
table and observation_period table will be considered.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
library(CDMConnector)
library(dplyr, warn.conflicts = FALSE)

con <- DBI::dbConnect(duckdb::duckdb(), eunomia_dir())

cdm <- cdm_from_con(con, cdm_schema = "main")

cdmSampled <- cdmSample(cdm, n = 2)

cdmSampled$person \%>\%
  select(person_id)
#> # Source:   SQL [2 x 1]
#> # Database: DuckDB 0.6.1
#>   person_id
#>       <dbl>
#> 1       155
#> 2      3422

DBI::dbDisconnect(con, shutdown = TRUE)
}
}
