% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pies.R
\name{add_PieLegend}
\alias{add_PieLegend}
\title{Add a legend to Pies}
\usage{
add_PieLegend(
  Pies = NULL,
  PosX = 0,
  PosY = 0,
  Size = 25,
  lwd = 1,
  Boxexp = c(0.2, 0.2, 0.12, 0.3),
  Boxbd = "white",
  Boxlwd = 1,
  Labexp = 0.3,
  fontsize = 1,
  LegSp = 0.5,
  Horiz = TRUE,
  PieTitle = "Pie chart",
  SizeTitle = "Size chart",
  PieTitleVadj = 0.5,
  SizeTitleVadj = 0.3,
  nSizes = 3,
  SizeClasses = NULL
)
}
\arguments{
\item{Pies}{Spatial object created using \link{create_Pies}.}

\item{PosX}{numeric, horizontal adjustment of legend.}

\item{PosY}{numeric, vertical adjustment of legend.}

\item{Size}{numeric value controlling the size of pies.}

\item{lwd}{numeric value controlling the line thickness of pies.}

\item{Boxexp}{numeric vector of length 4 controlling the expansion of the legend box, given
as \code{c(xmin,xmax,ymin,ymax)}.}

\item{Boxbd}{color of the background of the legend box.}

\item{Boxlwd}{numeric value controlling the line thickness of the legend box.}

\item{Labexp}{numeric value controlling the distance of the pie labels to the center of the pie.}

\item{fontsize}{Size of the legend font.}

\item{LegSp}{Numeric, spacing between the pie and the size chart (only used if \code{SizeVar}
was specified in \link{create_Pies}).}

\item{Horiz}{Logical. Set to FALSE if vertical layout is desired (only used if \code{SizeVar}
was specified in \link{create_Pies}).}

\item{PieTitle}{Character, title of the pie chart.}

\item{SizeTitle}{Character, title of the size chart (only used if \code{SizeVar}
was specified in \link{create_Pies}).}

\item{PieTitleVadj}{numeric value controlling the vertical adjustment of the title of the pie chart.}

\item{SizeTitleVadj}{numeric value controlling the vertical adjustment of the title of the size chart (only used if \code{SizeVar}
was specified in \link{create_Pies}).}

\item{nSizes}{integer, number of size classes to display in the size chart. Minimum and maximum sizes are
displayed by default. (only used if \code{SizeVar} was specified in \link{create_Pies}).}

\item{SizeClasses}{numeric vector (e.g. c(1,10,100)) to select the size classes to display in the size chart
(only used if \code{SizeVar} was specified in \link{create_Pies}). If set, overrides \code{nSizes}.}
}
\value{
Adds a legend to a pre-existing plot.
}
\description{
Adds a legend to pies created using \link{create_Pies}.
}
\examples{
#Example 1. Pies of constant size, all classes displayed:
#Create pies
MyPies=create_Pies(Input=PieData,
                   NamesIn=c("Lat","Lon","Sp","N"),
                   Size=50
                   )
#Plot Pies
plot(MyPies,col=MyPies$col)
#Add Pies legend
add_PieLegend(Pies=MyPies,PosX=-0.1,PosY=-1,Boxexp=c(0.5,0.45,0.12,0.45),
             PieTitle="Species")


#Example 2. Pies of constant size, selected classes displayed:
#Create pies
MyPies=create_Pies(Input=PieData,
                   NamesIn=c("Lat","Lon","Sp","N"),
                   Size=50,
                   Classes=c("TOP","TOA","ANI")
                   )
#Plot Pies
plot(MyPies,col=MyPies$col)
#Add Pies legend
add_PieLegend(Pies=MyPies,PosX=-0.1,PosY=-1,Boxexp=c(0.6,0.6,0.12,0.55),
              PieTitle="Selected species")


#Example 3. Pies of constant size, proportions below 25\% are grouped in a 'Other' class
#(N.B.: unlike Example 2, the 'Other' class may contain classes that are displayed in the legend.
#Please compare Example 1 and Example 3)
#Create pies
MyPies=create_Pies(Input=PieData,
                   NamesIn=c("Lat","Lon","Sp","N"),
                   Size=50,
                   Other=25
                   )
#Plot Pies
plot(MyPies,col=MyPies$col)
#Add Pies legend
add_PieLegend(Pies=MyPies,PosX=-0.1,PosY=-1,Boxexp=c(0.55,0.55,0.12,0.45),
              PieTitle="Other (\%) class")


#Example 4. Pies of variable size (here, their area is proportional to 'Catch'),
#all classes displayed, horizontal legend:
#Create pies
MyPies=create_Pies(Input=PieData,
                   NamesIn=c("Lat","Lon","Sp","N"),
                   Size=18,
                   SizeVar="Catch"
                   )
#Plot Pies
plot(MyPies,col=MyPies$col)
#Add Pies legend
add_PieLegend(Pies=MyPies,PosX=-0.3,PosY=-0.8,Boxexp=c(0.16,0.1,0.1,0.4),
              PieTitle="Species",SizeTitle="Catch (t.)")


#Example 5. Pies of variable size (here, their area is proportional to 'Catch'),
#all classes displayed, vertical legend:
#Create pies
MyPies=create_Pies(Input=PieData,
                   NamesIn=c("Lat","Lon","Sp","N"),
                   Size=18,
                   SizeVar="Catch"
                   )
#Plot Pies
plot(MyPies,col=MyPies$col)
#Add Pies legend
add_PieLegend(Pies=MyPies,PosX=-1.7,PosY=0.1,Boxexp=c(0.35,0.32,0.02,0.15),
              PieTitle="Species",SizeTitle="Catch (t.)",Horiz=FALSE,LegSp=0.6)


#Example 6. Pies of constant size, all classes displayed.
#Too many pies (see next example for solution):
#Create pies
MyPies=create_Pies(Input=PieData2,
                   NamesIn=c("Lat","Lon","Sp","N"),
                   Size=5
                   )
#Plot Pies
plot(MyPies,col=MyPies$col)
#Add Pies legend
add_PieLegend(Pies=MyPies,PosX=-0.8,PosY=-0.1,Boxexp=c(0.5,0.45,0.12,0.45),
              PieTitle="Species")


#Example 7. Pies of constant size, all classes displayed. Gridded locations (in which case numerical
#variables in the 'Input' are summed for each grid point):
#Create pies
MyPies=create_Pies(Input=PieData2,
                   NamesIn=c("Lat","Lon","Sp","N"),
                   Size=5,
                   GridKm=250
                   )
#Plot Pies
plot(MyPies,col=MyPies$col)
#Add Pies legend
add_PieLegend(Pies=MyPies,PosX=-0.8,PosY=-0.1,Boxexp=c(0.5,0.45,0.12,0.45),
              PieTitle="Species")


#Example 8. Pies of variable size (here, their area is proportional to 'Catch'),
#all classes displayed, vertical legend, gridded locations (in which case numerical
#variables in the 'Input' are summed for each grid point):
MyPies=create_Pies(Input=PieData2,
                   NamesIn=c("Lat","Lon","Sp","N"),
                   Size=3,
                   GridKm=250,
                   SizeVar='Catch'
                   )
#Plot Pies
plot(MyPies,col=MyPies$col)
#Add Pies legend
add_PieLegend(Pies=MyPies,PosX=-1.2,PosY=0.3,Boxexp=c(0.38,0.32,0.08,0.18),
              PieTitle="Species",Horiz=FALSE,SizeTitle="Catch (t.)",
              SizeTitleVadj=0.8,nSizes=2)



}
\seealso{
\code{\link{create_Pies}}, \code{\link{PieData}}, \code{\link{PieData2}}.
}
