% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCAMLRGIS_DataDescription.R
\docType{data}
\name{PieData}
\alias{PieData}
\title{Example dataset for create_Pies}
\format{
DataFrame
}
\usage{
data(PieData)
}
\description{
To be used in conjunction with \link{create_Pies}. Count of species per location.
}
\examples{
#View(PieData)

#Create pies
MyPies=create_Pies(Input=PieData,
                   NamesIn=c("Lat","Lon","Sp","N"),
                   Size=50
)
#Plot Pies
plot(MyPies,col=MyPies$col)
#Add Pies legend
add_PieLegend(Pies=MyPies,PosX=-0.1,PosY=-1.6,Boxexp=c(0.5,0.45,0.12,0.45),
              PieTitle="Species")

}
\seealso{
\code{\link{create_Pies}}.
}
