% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_report.R
\name{make_report}
\alias{make_report}
\title{Prepare and render the HTML5 report}
\usage{
make_report(defs, render.report = TRUE)
}
\arguments{
\item{defs}{an enriched `CALANGO`-type list generated by `run_CALANGO()`}

\item{render.report}{logical: should the HTML5 report be generated (for
internal use only)}
}
\value{
Updated `defs` list, containing:
\itemize{
   \item All input parameters originally passed (see [run_CALANGO()] for 
   details).
   \item Derived fields calculated for displaying the results, including 
   several statistical summaries of the data (including correlations, 
   contrasts, covariances, p-values).
}

This function is mainly called for its side effect, namely the generation of 
an HTML5 report of the analysis, which is saved to the folder indicated in 
`defs$output.dir`.
}
\description{
This script generates the HTML5 report based on an enriched
`CALANGO`-type list output by `run_CALANGO()`.
}
