/*
 * To change this template,  choose Tools | Templates
 * and open the template in the editor.
 */
package org.neptuneinc.cadstat.ui;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;

import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRDataFileOpenDialog;

/**
 *
 * @author  Pasha Minallah
 */
public class DatasetPane extends JPanel
{
  
  /** Creates new form DataPane */
  public DatasetPane()
  {
    this.initComponents();
    
    this.refreshDatasetComboBox();
  }
  
  public String getSelectedDataset()
  {
    return (GUIUtils.getSelectedItem(this.getDatasetComboBox()));
  }
  
  public void refreshDatasetComboBox()
  {
    Object[] datasets = RUtils.getDatasetList();
    
    if (datasets != null && datasets.length > 0)
    {
      getDatasetComboBox().setModel(new DefaultComboBoxModel(datasets));
      getDatasetComboBox().setSelectedIndex(0);
    }
    
    else
    {
      getDatasetComboBox().removeAllItems();
    }
    
    this.refreshDatasetComboBoxValidity();
  }
  
  public void refreshDatasetComboBoxValidity()
  {
    getDatasetComboBox().setEnabled(this.getDatasetComboBox().getItemCount() > 0);
  }
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    datasetLabel = new javax.swing.JLabel();
    datasetComboBox = new javax.swing.JComboBox();
    browseButton = new javax.swing.JButton();

    datasetLabel.setLabelFor(datasetComboBox);
    datasetLabel.setText("Dataset:");

    datasetComboBox.setPreferredSize(new java.awt.Dimension(120, 24));

    browseButton.setText("Browse...");
    browseButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        browseButtonActionPerformed(evt);
      }
    });

    org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(layout.createSequentialGroup()
        .add(datasetLabel)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(datasetComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 176, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(browseButton))
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
        .add(datasetLabel)
        .add(datasetComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        .add(browseButton))
    );
  }// </editor-fold>//GEN-END:initComponents

  private void browseButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_browseButtonActionPerformed
  {//GEN-HEADEREND:event_browseButtonActionPerformed
    new JGRDataFileOpenDialog(JGR.MAINRCONSOLE, RUtils.evalAsString("getwd()"));

    this.refreshDatasetComboBox();
    this.getDatasetComboBox().grabFocus();
  }//GEN-LAST:event_browseButtonActionPerformed
      
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton browseButton;
  private javax.swing.JComboBox datasetComboBox;
  private javax.swing.JLabel datasetLabel;
  // End of variables declaration//GEN-END:variables

  public JComboBox getDatasetComboBox()
  {
    return datasetComboBox;
  }

  public void setDatasetComboBox(JComboBox datasetComboBox)
  {
    this.datasetComboBox = datasetComboBox;
  }

  public void setDatasetLabel(JLabel datasetLabel)
  {
    this.datasetLabel = datasetLabel;
  }

  public JLabel getDatasetLabel()
  {
    return datasetLabel;
  }
  
}
