% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blanket_statsments.R
\name{redundancy_analysis}
\alias{redundancy_analysis}
\title{Redundancy analysis}
\usage{
redundancy_analysis(model, data, r2_threshold = 0.9, nk = 0)
}
\arguments{
\item{model}{a statistical regression model of class linear, logistic or coxph}

\item{data}{data.frame used to create the model}

\item{r2_threshold}{float threshold value to consider a parameter redundant}

\item{nk}{number of knots in splicing}
}
\value{
an object of class "redun"
}
\description{
Perform a redundancy analysis on an existing model
}
\examples{
data <- survival::lung
mod <- build_reg_model(data, 'age', c('sex'))
redundancy_analysis(mod, data)

}
\author{
J. Peter Marquardt
}
