% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bland.altman.R
\name{bland.altman.plot}
\alias{bland.altman.plot}
\title{Produce Bland-Altman Plot
 
Bland-AltmanPlots for assessing agreement between two measuring methods or
repeatability (test-retest agreement) of measurements. Focus on base graphics
but ggplot2 is available, for consistency with your other plots. No ggvis 
available so far.}
\usage{
bland.altman.plot(group1, group2, two = 1.96, mode = 1,
  graph.sys = "base", conf.int = 0, silent = TRUE, sunflower = FALSE,
  ...)
}
\arguments{
\item{group1}{Measurements with first method or first measurement}

\item{group2}{Measurements with second method or second measurement}

\item{two}{Lines are drawn "two" standard deviations from mean differences.
This defaults to 1.96 for proper 95 percent confidence interval estimation
but can be set to 2.0.}

\item{mode}{if 1 then difference group1 minus group2 is used, if 2 then
group2 minus group1 is used. Defaults to 1.}

\item{graph.sys}{Graphing system within R. This defaults to "base" but can be
one out of \code{c("base", "ggplot2")}. At the time given, only "base" will 
provide full functionality. There is however some ggplot2 functionality (see examples).}

\item{conf.int}{Defaults to 0 which draws the usual Bland Altman plot which 
contains no confidence intervalls. Change to .95 for 95 percent confidence
intervalls to be drawn.}

\item{silent}{logical. If TRUE then no return value. If FALSE then returns 
statistics}

\item{sunflower}{logical. If TRUE, the plot will be based on a sunflower plot
and ties will be marked accordingly. Try with data with ties. Works only with
\code{graph.sys=="base"}.}

\item{...}{passed on to graphics functions if \code{graph.sys=="base"}}
}
\value{
If silent==TRUE no returns. If silent==FALSE than returns list of
statistics as returned by \code{bland.altman.stats()}.
}
\description{
Produce Bland-Altman Plot
 
Bland-AltmanPlots for assessing agreement between two measuring methods or
repeatability (test-retest agreement) of measurements. Focus on base graphics
but ggplot2 is available, for consistency with your other plots. No ggvis 
available so far.
}
\examples{
bland.altman.plot(rnorm(20), rnorm(20), xlab="mean measurement", 
                  ylab="differences", main="Example plot")
                  
bland.altman.plot(rnorm(20), 2+.8*rnorm(20), xlab="mean measurement", 
                  ylab="differences", conf.int=.95)
                  
bland.altman.plot(rnorm(200), 2+.8*rnorm(200), xlab="mean measurement", 
                  ylab="differences", conf.int=.95)
                  
# this is what fig.2 in Bland&Altman1986 whould have looked like
PEFR1 <- bland.altman.PEFR[,1]
PEFR2 <- bland.altman.PEFR[,3]
bland.altman.plot(PEFR1, PEFR2, silent=TRUE, xlim=c(0,800),
                  xlab="Average PEFR by two meters",
                  ylab="Difference in PEFR (large-mini)")

# and this is the same but with additional 95 percent CIs
bland.altman.plot(PEFR1, PEFR2, silent=TRUE, conf.int=.95, xlim=c(0,800))
                  
# an example with many ties and the 'sunflower'-option
a <- rep(c(1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,5,6,6),2)
b <- rep(c(1,1,1,2,2,2,3,1,4,2,5,3,3,3,3,3),3)
bland.altman.plot(a,b,sunflower=TRUE, xlab="Mean",ylab="Difference",
                  main="discrete values lead to ties")
                  
# only very basic support for ggplot2 yet:
library(ggplot2)
a <- bland.altman.plot(rnorm(20), rnorm(20), graph.sys="ggplot2", conf.int=.9)
print(a + xlab("you can change this later") + ggtitle("Title goes here"))                  
}
\author{
Bernhard Lehnert <bernhard.lehnert@uni-greifswald.de>
}
\seealso{
\code{\link{bland.altman.stats}}
}

