% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/473-extractDrugGraph.R
\name{extrDrugGraphComplete}
\alias{extrDrugGraphComplete}
\title{Calculate the Graph Molecular Fingerprints (in Complete Format)}
\usage{
extrDrugGraphComplete(molecules, depth = 6, size = 1024,
  silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{depth}{The search depth. Default is \code{6}.}

\item{size}{The length of the fingerprint bit string. Default is \code{1024}.}

\item{silent}{Logical. Whether the calculating process 
should be shown or not, default is \code{TRUE}.}
}
\value{
An integer vector or a matrix. Each row represents one molecule, 
the columns represent the fingerprints.
}
\description{
Calculate the Graph Molecular Fingerprints (in Complete Format)
}
\details{
Calculate the graph molecular fingerprints. 
Similar to the standard type by simply considers connectivity.
This is hashed fingerprints, with a default length of 1024.
}
\examples{
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
fp  = extrDrugGraphComplete(mol)
dim(fp)

}
\seealso{
\link{extrDrugGraph}
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{extrDrugGraphComplete}
