% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.peaks.R
\name{call.peaks}
\alias{call.peaks}
\title{Call peaks from a list of window-level p-values}
\usage{
call.peaks(window.pvals, method = c("BY", "BH", "none"), start, end,
  chromosomes, alpha = 0.05)
}
\arguments{
\item{window.pvals}{Vector of p-values, with each element corresponding to a 
window of a genomic partition. Typically obtained from the 
\code{\link{QL.fit}} and \code{\link{QL.results}} functions.}

\item{method}{Correction method applied to \code{window.pvals}. Must be one 
of \code{"BH"}, \code{"BY"}, or \code{"none"} to specify Benjamini-Hochberg, 
Benjamini-Yekutieli, or no adjustment, respectively.}

\item{start}{Vector of the genomic start locations corresponding to the 
supplied p-values.}

\item{end}{Vector of the genomic end locations corresponding to the supplied 
p-values.}

\item{chromosomes}{Vector of the chromosome names corresponding to the 
supplied p-values.}

\item{alpha}{The desired significance threshold in (0, 0.5).}
}
\value{
The called peaks as a dataframe with variables: 
  \item{start}{Genomic start locations of the called peaks.} 
  \item{end}{Genomic end locations of the called peaks.} 
  \item{width}{Width of the called peaks.} 
  \item{chr}{Chromosomes of the called peaks.} 
  \item{P.val}{p-values of the  called peaks (aggregated from the windows 
  comprising the peak using Simes' procedure).} 
  \item{Q.val}{q-values of the called peaks (computing using the
  Benjamini-Hochberg procedure).}
}
\description{
Call peaks from a list of p-values corresponding to window-level
  tests on a genomic partition of ChIP-seq counts. Used within the main peak
  calling function, \code{\link{BQ}}.
}
\details{
After correcting for multiple testing using the adjustment specified
  by \code{method}, windows that are significant according to the threshold 
  \code{alpha} are merged if adjacent and retained as candidate regions. 
  Simes' procedure is used to combine the window-level p-values in each 
  candidate region into a region-level p-value. The Benjamini-Hochberg 
  procedure is applied to the resulting candidate regions and those that 
  exceed the significance threshold \code{alpha} are returned as peaks.
}
\examples{
# Example for a single chromosome.
start <- seq(1, 1e6, by = 200)
end <- start + 200 - 1
chromosomes <- rep('chr1', length(start))
p <- c(runif(length(start) - 10), rep(1e-12, 10))
called <- call.peaks(p, "BH", start, end, chromosomes)
called

}
\references{
Benjamini and Hochberg (1995) "Controlling the false discovery 
  rate: a practical and powerful approach to multiple testing" \emph{Journal
  of the Royal Statistical Society Series B}, \bold{57}: 289-300.
  
  Benjamini and Yekutieli (2001) "The control of the false discovery rate in 
  multiple testing under dependency" \emph{Annals of Statistics}. \bold{29}: 
  1165-1188.
  
  Simes (1986) "An improved Bonferroni procedure for multiple tests of 
  significance" \emph{Biometrika}, \bold{73}(3): 751-754.
}
\author{
Emily Goren (\email{emily.goren@gmail.com}).
}
