% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdblockmult_sparse_hdf5}
\alias{bdblockmult_sparse_hdf5}
\title{Block matrix multiplication with Delayed Array Object}
\usage{
bdblockmult_sparse_hdf5(filename, group, A, B, outgroup = NULL)
}
\arguments{
\item{filename}{string file name where dataset to normalize is stored}

\item{group}{string or Delayed Array Matrix}

\item{A, }{string with dataset name where matrix is stored}

\item{B, }{string with dataset name where matrix is stored}

\item{outgroup}{string with de group name under the matrix will be stored}
}
\value{
list with filename and the group and dataset name under the results are stored
}
\description{
This function performs a block matrix-matrix multiplication with numeric matrix or Delayed Arrays
}
\examples{

library(Matrix)
library(BigDataStatMeth)

k <- 1e3
set.seed(1)
x_sparse <- sparseMatrix(
    i = sample(x = k, size = k),
    j = sample(x = k, size = k),
    x = rnorm(n = k)
)
set.seed(2)
y_sparse <- sparseMatrix(
    i = sample(x = k, size = k),
    j = sample(x = k, size = k),
    x = rnorm(n = k)
)

if( isTRUE(file.exists('BasicMatVect.hdf5'))) {
     file.remove('BasicMatVect.hdf5')
}
bdCreate_hdf5_matrix_file("BasicMatVect.hdf5", as.matrix(x_sparse), "SPARSE", "x_sparse")
bdAdd_hdf5_matrix(as.matrix(y_sparse), "BasicMatVect.hdf5", "SPARSE", "y_sparse")

d <- bdblockmult_sparse_hdf5("BasicMatVect.hdf5", "SPARSE", "x_sparse", "y_sparse")

# Remove file (used as example)
if (file.exists("BasicMatVect.hdf5")) {
  # Delete file if it exist
  file.remove("BasicMatVect.hdf5")
}

}
