% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataProvTables.R
\name{dataProvTables}
\alias{dataProvTables}
\title{Build a table of data providers for bee occurrence records}
\usage{
dataProvTables(
  data = NULL,
  runBeeDataChecks = FALSE,
  outPath = OutPath_Report,
  fileName = NULL
)
}
\arguments{
\item{data}{A data frame or tibble. Occurrence records as input.}

\item{runBeeDataChecks}{Logical. If TRUE, will search in other columns for specific clues to
determine the institution.}

\item{outPath}{A character path. The path to the directory in which the figure will be saved.
Default = OutPath_Report.}

\item{fileName}{Character. The name of the file to be saved, ending in ".csv".}
}
\value{
Returns a table with the data providers, an specimen count, and a species count.
}
\description{
This function will attempt to find and build a table of data providers that have contributed
to the input data, especially using the 'institutionCode' column. It will also look for a
variety of other columns to find data providers using an internally set sequence of if-else
statements. Hence, this function is quite specific for bee data, but should work for other
taxa in similar institutions.
}
\examples{

data(beesFlagged)

testOut <- dataProvTables(
data = beesFlagged,
runBeeDataChecks = TRUE,
outPath = tempdir(),
fileName = "testFile.csv")

}
