/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.xml.ClassComparator;
import dr.xml.XMLDocumentationHandler;
import dr.xml.XMLObject;
import dr.xml.XMLSyntaxRule;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class ElementRule
implements XMLSyntaxRule {
    private Class c = null;
    private String name = null;
    private XMLSyntaxRule[] rules = null;
    private int min = 1;
    private int max = 1;
    private String description = null;
    private String example = null;

    public ElementRule(Class clazz) {
        this(clazz, null, null, 1, 1);
    }

    public ElementRule(Class clazz, boolean bl) {
        this(clazz, null, null, bl ? 0 : 1, 1);
    }

    public ElementRule(Class clazz, String string) {
        this(clazz, string, null, 1, 1);
    }

    public ElementRule(Class clazz, int n, int n2) {
        this(clazz, null, null, n, n2);
    }

    public ElementRule(Class clazz, String string, String string2) {
        this(clazz, string, string2, 1, 1);
    }

    public ElementRule(Class clazz, String string, int n, int n2) {
        this(clazz, string, null, n, n2);
    }

    public ElementRule(Class clazz, String string, String string2, int n, int n2) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null!");
        }
        this.c = clazz;
        this.min = n;
        this.max = n2;
        this.description = string;
        this.example = string2;
    }

    public ElementRule(String string, Class clazz) {
        this.name = string;
        this.rules = new XMLSyntaxRule[]{new ElementRule(clazz)};
    }

    public ElementRule(String string, Class clazz, String string2) {
        this.name = string;
        this.description = string2;
        this.rules = new XMLSyntaxRule[]{new ElementRule(clazz)};
    }

    public ElementRule(String string, Class clazz, String string2, boolean bl) {
        this.name = string;
        this.description = string2;
        this.rules = new XMLSyntaxRule[]{new ElementRule(clazz)};
        this.min = 1;
        this.max = 1;
        if (bl) {
            this.min = 0;
        }
    }

    public ElementRule(String string, Class clazz, String string2, int n, int n2) {
        this.name = string;
        this.description = string2;
        this.rules = new XMLSyntaxRule[]{new ElementRule(clazz)};
        this.min = n;
        this.max = n2;
    }

    public ElementRule(String string, XMLSyntaxRule[] xMLSyntaxRuleArray) {
        this.name = string;
        this.rules = xMLSyntaxRuleArray;
    }

    public ElementRule(String string, XMLSyntaxRule[] xMLSyntaxRuleArray, boolean bl) {
        this.name = string;
        this.rules = xMLSyntaxRuleArray;
        this.min = 1;
        this.max = 1;
        if (bl) {
            this.min = 0;
        }
    }

    public ElementRule(String string, XMLSyntaxRule[] xMLSyntaxRuleArray, int n, int n2) {
        this.name = string;
        this.rules = xMLSyntaxRuleArray;
        this.min = n;
        this.max = n2;
    }

    public ElementRule(String string, XMLSyntaxRule[] xMLSyntaxRuleArray, String string2) {
        this.name = string;
        this.rules = xMLSyntaxRuleArray;
        this.description = string2;
    }

    public ElementRule(String string, XMLSyntaxRule[] xMLSyntaxRuleArray, String string2, boolean bl) {
        this.name = string;
        this.rules = xMLSyntaxRuleArray;
        this.description = string2;
        this.min = 1;
        this.max = 1;
        if (bl) {
            this.min = 0;
        }
    }

    public ElementRule(String string, XMLSyntaxRule[] xMLSyntaxRuleArray, String string2, int n, int n2) {
        this.name = string;
        this.rules = xMLSyntaxRuleArray;
        this.description = string2;
        this.min = n;
        this.max = n2;
    }

    public Class getElementClass() {
        return this.c;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getExample() {
        return this.example;
    }

    public boolean hasExample() {
        return this.example != null;
    }

    @Override
    public boolean isSatisfied(XMLObject xMLObject) {
        int n;
        int n2 = 0;
        for (n = 0; n < xMLObject.getChildCount(); ++n) {
            Object object = xMLObject.getChild(n);
            if (!(object instanceof XMLObject) || !((XMLObject)object).getName().equals(this.name)) continue;
            ++n2;
        }
        if (this.min == 0 && n2 == 0) {
            return true;
        }
        n = 0;
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            Object object = xMLObject.getChild(i);
            if (!this.isCompatible(object)) continue;
            ++n;
        }
        return n >= this.min && n <= this.max;
    }

    @Override
    public boolean containsAttribute(String string) {
        return false;
    }

    @Override
    public String ruleString() {
        String string = this.min == 1 && this.max == 1 ? "Exactly one" : (this.min == this.max ? "Exactly " + this.min : (this.min <= 1 && this.max == Integer.MAX_VALUE ? "Any number of" : "between " + this.min + " and " + this.max));
        if (this.c != null) {
            return string + " ELEMENT of type " + this.getTypeName() + " REQUIRED";
        }
        StringBuffer stringBuffer = new StringBuffer(string + " ELEMENT of name " + this.name + " REQUIRED containing");
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            stringBuffer.append("\n    ").append(xMLSyntaxRule.ruleString());
        }
        return stringBuffer.toString();
    }

    @Override
    public String htmlRuleString(XMLDocumentationHandler xMLDocumentationHandler) {
        if (this.c != null) {
            String string = "<div class=\"" + (this.min == 0 ? "optional" : "required") + "rule\">" + xMLDocumentationHandler.getHTMLForClass(this.c);
            if (this.max > 1) {
                string = string + " elements (";
                if (this.min == 0) {
                    string = string + "zero";
                } else if (this.min == 1) {
                    string = string + "one";
                } else if (this.min == this.max) {
                    string = string + "exactly " + this.min;
                }
                if (this.max != this.min) {
                    string = this.max < Integer.MAX_VALUE ? string + " to " + this.max : string + " or more";
                }
            } else {
                string = string + " element (";
                string = this.min == 0 ? string + "zero or one" : string + "exactly one";
            }
            string = string + ")";
            if (this.hasDescription()) {
                string = string + "<div class=\"description\">" + this.getDescription() + "</div>\n";
            }
            return string + "</div>\n";
        }
        StringBuffer stringBuffer = new StringBuffer("<div class=\"" + (this.min == 0 ? "optional" : "required") + "compoundrule\">Element named <span class=\"elemname\">" + this.name + "</span> containing:");
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            stringBuffer.append(xMLSyntaxRule.htmlRuleString(xMLDocumentationHandler));
        }
        if (this.hasDescription()) {
            stringBuffer.append("<div class=\"description\">").append(this.getDescription()).append("</div>\n");
        }
        stringBuffer.append("</div>\n");
        return stringBuffer.toString();
    }

    @Override
    public String wikiRuleString(XMLDocumentationHandler xMLDocumentationHandler, String string) {
        if (this.c != null) {
            String string2 = string + xMLDocumentationHandler.getHTMLForClass(this.c);
            if (this.max > 1) {
                string2 = string2 + " elements (";
                if (this.min == 0) {
                    string2 = string2 + "zero";
                } else if (this.min == 1) {
                    string2 = string2 + "one";
                } else if (this.min == this.max) {
                    string2 = string2 + "exactly " + this.min;
                }
                if (this.max != this.min) {
                    string2 = this.max < Integer.MAX_VALUE ? string2 + " to " + this.max : string2 + " or more";
                }
            } else {
                string2 = string2 + " element (";
                string2 = this.min == 0 ? string2 + "zero or one" : string2 + "exactly one";
            }
            string2 = string2 + ")\n";
            string2 = this.hasDescription() ? string2 + string + ":''" + this.getDescription() + "''\n" : string2 + string + ":\n";
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string + "Element named <code>&lt;" + this.name + "&gt;</code> containing:\n");
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            stringBuffer.append(xMLSyntaxRule.wikiRuleString(xMLDocumentationHandler, string + "*"));
        }
        if (this.hasDescription()) {
            stringBuffer.append(string).append("*:''").append(this.getDescription()).append("''\n");
        } else {
            stringBuffer.append(string).append("*:\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public String markdownRuleString(XMLDocumentationHandler xMLDocumentationHandler, String string) {
        if (this.c != null) {
            String string2 = string + "* " + xMLDocumentationHandler.getHTMLForClass(this.c);
            if (this.max > 1) {
                string2 = string2 + " elements (";
                if (this.min == 0) {
                    string2 = string2 + "zero";
                } else if (this.min == 1) {
                    string2 = string2 + "one";
                } else if (this.min == this.max) {
                    string2 = string2 + "exactly " + this.min;
                }
                if (this.max != this.min) {
                    string2 = this.max < Integer.MAX_VALUE ? string2 + " to " + this.max : string2 + " or more";
                }
            } else {
                string2 = string2 + " element (";
                string2 = this.min == 0 ? string2 + "zero or one" : string2 + "exactly one";
            }
            string2 = string2 + ")\n";
            string2 = this.hasDescription() ? string2 + ": " + this.getDescription() + "\n\n" : string2 + "\n";
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string + "* Element named <code>&lt;" + this.name + "&gt;</code>\n");
        if (this.hasDescription()) {
            stringBuffer.append(": ").append(this.getDescription()).append("\n\n");
        } else {
            stringBuffer.append("\n");
        }
        if (this.rules.length > 0) {
            stringBuffer.append(string + "    Containing:\n\n");
        }
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            stringBuffer.append(xMLSyntaxRule.markdownRuleString(xMLDocumentationHandler, string + "    "));
        }
        return stringBuffer.toString();
    }

    @Override
    public String ruleString(XMLObject xMLObject) {
        return this.ruleString();
    }

    public boolean isAttributeRule() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public XMLSyntaxRule[] getRules() {
        return this.rules;
    }

    private boolean isCompatible(Object object) {
        if (this.rules != null) {
            XMLObject xMLObject;
            if (object instanceof XMLObject && (xMLObject = (XMLObject)object).getName().equals(this.name)) {
                for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
                    if (xMLSyntaxRule.isSatisfied(xMLObject)) continue;
                    return false;
                }
                return true;
            }
        } else {
            if (this.c == null) {
                return true;
            }
            if (this.c.isInstance(object)) {
                return true;
            }
            if (object instanceof String) {
                if (this.c == Double.class) {
                    try {
                        Double.parseDouble((String)object);
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                if (this.c == Integer.class) {
                    try {
                        Integer.parseInt((String)object);
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                if (this.c == Float.class) {
                    try {
                        Float.parseFloat((String)object);
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                if (this.c == Boolean.class) {
                    return object.equals("true") || object.equals("false");
                }
                if (this.c == Number.class) {
                    try {
                        Double.parseDouble((String)object);
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
            }
        }
        return false;
    }

    private String getTypeName() {
        if (this.c == null) {
            return "Object";
        }
        String string = this.c.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    @Override
    public Set<Class> getRequiredTypes() {
        if (this.c != null) {
            return Collections.singleton(this.c);
        }
        TreeSet<Class> treeSet = new TreeSet<Class>(ClassComparator.INSTANCE);
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            treeSet.addAll(xMLSyntaxRule.getRequiredTypes());
        }
        return treeSet;
    }

    @Override
    public boolean isLegalElementName(String string) {
        return this.c == null && this.name != null && this.name.equals(string);
    }

    @Override
    public boolean isLegalElementClass(Class clazz) {
        return this.c != null && this.c.isAssignableFrom(clazz);
    }

    @Override
    public boolean isLegalSubelementName(String string) {
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            if (!xMLSyntaxRule.isLegalElementName(string)) continue;
            return true;
        }
        return false;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public String toString() {
        return this.ruleString();
    }
}

