/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FrequencySet<T> {
    private List<Bin> list = new ArrayList<Bin>();
    private Map<T, Bin> binMap = new HashMap<T, Bin>();
    private boolean sorted = false;
    private int size = 0;
    private Comparator<Bin> frequencyComparator = new Comparator<Bin>(){

        @Override
        public int compare(Bin bin, Bin bin2) {
            return bin2.frequency - bin.frequency;
        }
    };

    public int size() {
        return this.size;
    }

    public T get(int n) {
        if (!this.sorted) {
            this.sortByFrequency();
        }
        return this.list.get((int)n).object;
    }

    protected int getFrequency(T t) {
        Bin bin = this.binMap.get(t);
        if (bin == null) {
            return 0;
        }
        return bin.frequency;
    }

    public int getFrequency(int n) {
        if (!this.sorted) {
            this.sortByFrequency();
        }
        return this.list.get((int)n).frequency;
    }

    public int getSumFrequency() {
        int n = 0;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            n += this.getFrequency(i);
        }
        return n;
    }

    public void add(T t) {
        this.add(t, 1);
    }

    public void add(T t, int n) {
        Bin bin = this.binMap.get(t);
        if (bin != null) {
            ++bin.frequency;
        } else {
            bin = new Bin(t, n);
            this.binMap.put(t, bin);
            ++this.size;
            this.sorted = false;
        }
    }

    public Set<T> getKeySet() {
        return this.binMap.keySet();
    }

    public boolean equals(Object object) {
        return object instanceof FrequencySet && this.binMap.keySet().equals(((FrequencySet)object).binMap.keySet());
    }

    private void sortByFrequency() {
        this.list.clear();
        for (Bin bin : this.binMap.values()) {
            this.list.add(bin);
        }
        Collections.sort(this.list, this.frequencyComparator);
        this.sorted = true;
    }

    private class Bin {
        T object;
        int frequency;

        public Bin(T t, int n) {
            this.object = t;
            this.frequency = n;
        }

        public boolean equals(Object object) {
            return this.object.equals(((Bin)object).object);
        }

        public int hashCode() {
            return this.object.hashCode();
        }
    }
}

