/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class EmpiricalRateMatrixReader {
    protected double[] rates;
    protected double[] frequencies;
    private String name;
    protected String dataDir;
    protected String matName;
    protected String freqName;
    protected DataType dataType;

    public EmpiricalRateMatrixReader(String string, DataType dataType, String string2, String string3, String string4) {
        this.name = string;
        this.dataType = dataType;
        this.dataDir = string2;
        this.matName = string4;
        this.freqName = string3;
        this.setupRates();
        this.setupFreqs();
    }

    public final String getName() {
        return this.name;
    }

    public final DataType getDataType() {
        return this.dataType;
    }

    public double[] getRates() {
        return this.rates;
    }

    public double[] getFrequencies() {
        return this.frequencies;
    }

    public String getFreqName() {
        return this.freqName;
    }

    public String getMatName() {
        return this.matName;
    }

    public String getDirName() {
        return this.dataDir;
    }

    public void setFrequencies(double[] dArray) {
        this.frequencies = dArray;
    }

    public void setRates(double[] dArray) {
        this.rates = dArray;
    }

    private void setupRates() {
        this.rates = new double[1830];
        this.readFile(this.rates, this.matName, 1830);
    }

    private void setupFreqs() {
        this.frequencies = new double[61];
        this.readFile(this.frequencies, this.freqName, 61);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(double[] dArray, String string, int n) {
        File file = new File(this.dataDir, string);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    dArray[n2] = Double.valueOf(stringTokenizer.nextToken());
                    ++n2;
                }
            }
            bufferedReader.close();
            if (n2 != n) {
                Logger.getLogger("dr.evomodel").severe("Matrix does not contain " + n + " values but " + n2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger("dr.evomodel").severe("Caught FileNotFoundException: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            Logger.getLogger("dr.evomodel").severe("Caught IOException: " + iOException.getMessage());
        }
    }
}

