/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.IntegrableUnivariateFunction;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import no.uib.cipr.matrix.BandMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

public class SplineBasis
extends AbstractModel
implements IntegrableUnivariateFunction {
    public static final String SPLINE_BASIS = "splineFunction";
    public static final String KNOT_POINTS = "knotLocations";
    public static final String KNOT_VALUES = "knotValues";
    public static final String DEGREE = "degree";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("degree", true), new ElementRule("knotLocations", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("knotValues", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};

        @Override
        public String getParserName() {
            return SplineBasis.SPLINE_BASIS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n;
            int n2 = xMLObject.getAttribute(SplineBasis.DEGREE, 3);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(SplineBasis.KNOT_POINTS);
            Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild(SplineBasis.KNOT_VALUES);
            if (parameter.getDimension() != parameter2.getDimension()) {
                throw new XMLParseException("Spline basis knot locations and values must have the same dimension");
            }
            ArrayList<XY> arrayList = new ArrayList<XY>();
            for (n = 0; n < parameter.getDimension(); ++n) {
                arrayList.add(new XY(parameter.getParameterValue(n), parameter2.getParameterValue(n)));
            }
            Collections.sort(arrayList);
            for (n = 0; n < parameter.getDimension(); ++n) {
                XY xY = (XY)arrayList.get(n);
                parameter.setParameterValue(n, xY.x);
                parameter2.setParameterValue(n, xY.y);
            }
            return new SplineBasis(xMLObject.getId(), parameter, parameter2, n2);
        }

        @Override
        public String getParserDescription() {
            return "This element represents the a spline interpolation of discrete data.";
        }

        @Override
        public Class getReturnType() {
            return SplineBasis.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        class XY
        implements Comparable {
            private final double x;
            private final double y;

            public XY(double d, double d2) {
                this.x = d;
                this.y = d2;
            }

            public int compareTo(Object object) {
                double d = ((XY)object).x;
                if (d == this.x) {
                    throw new RuntimeException("No ties accepted in spline basis");
                }
                return Double.compare(this.x, d);
            }
        }
    };
    private final int degree;
    private final int n;
    private final Variable<Double> knotLocations;
    private final Variable<Double> knotValues;
    private boolean updateBasis;
    private double rangeMax;
    private double rangeMin;
    private final double[] h;
    private final double[] deltaY;
    private final Matrix hMatrix;
    private final Vector yByH;
    private final Vector z;

    public SplineBasis(String string, Variable<Double> variable, Variable<Double> variable2, int n) {
        super(string);
        this.knotLocations = variable;
        this.knotValues = variable2;
        this.addVariable(variable);
        this.addVariable(variable2);
        this.degree = n;
        this.updateBasis = true;
        this.n = variable2.getSize();
        this.h = new double[this.n - 1];
        this.deltaY = new double[this.n - 1];
        this.hMatrix = new BandMatrix(this.n, 1, 1);
        this.yByH = new DenseVector(this.n);
        this.z = new DenseVector(this.n);
        this.calculateBasis();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Constructing spline basis:\n");
        stringBuilder.append("\tDegree: ").append(n).append("\n");
        stringBuilder.append("\tRange: [").append(this.getLowerBound()).append(", ").append(this.getUpperBound()).append("\n");
        Logger.getLogger("dr.math").info(stringBuilder.toString());
    }

    public int getDegree() {
        return this.degree;
    }

    @Override
    public double evaluate(double d) {
        this.calculateBasis();
        int n = 0;
        double d2 = this.knotLocations.getValue(n);
        while (d2 < d) {
            d2 = this.knotLocations.getValue(++n);
        }
        double d3 = this.knotLocations.getValue(n + 1);
        double d4 = this.knotValues.getValue(n);
        double d5 = this.knotValues.getValue(n + 1);
        double d6 = this.z.get(n);
        double d7 = this.z.get(n + 1);
        double d8 = d3 - d2;
        return d7 * Math.pow(d - d2, 3.0) + d6 * Math.pow(d7 - d, 3.0) + (d5 / d8 - d8 / 6.0 * d7) * (d - d2) + (d4 / d8 - d8 / 6.0 * d6) * (d3 - d);
    }

    @Override
    public double getLowerBound() {
        return this.rangeMin;
    }

    @Override
    public double getUpperBound() {
        return this.rangeMax;
    }

    @Override
    public double evaluateIntegral(double d, double d2) {
        this.calculateBasis();
        return 0.0;
    }

    private void calculateBasis() {
        if (this.updateBasis) {
            int n;
            Double[] doubleArray = this.knotLocations.getValues();
            Double[] doubleArray2 = this.knotValues.getValues();
            this.rangeMin = doubleArray[0];
            this.rangeMax = doubleArray[doubleArray.length - 1];
            for (n = 0; n < this.n - 1; ++n) {
                this.h[n] = doubleArray[n + 1] - doubleArray[n];
                this.deltaY[n] = doubleArray2[n + 1] - doubleArray2[n];
            }
            this.hMatrix.set(0, 0, 1.0);
            this.yByH.set(0, 0.0);
            for (n = 1; n < this.n - 2; ++n) {
                this.hMatrix.set(n, n - 1, this.h[n - 1]);
                this.hMatrix.set(n, n, 2.0 * (this.h[n] + this.h[n - 1]));
                this.hMatrix.set(n, n + 1, this.h[n]);
                this.yByH.set(n, 6.0 * (this.deltaY[n] / this.h[n] - this.deltaY[n - 1] / this.h[n - 1]));
            }
            this.hMatrix.set(this.n - 1, this.n - 1, 1.0);
            this.yByH.set(this.n - 1, 0.0);
            this.hMatrix.solve(this.yByH, this.z);
            this.updateBasis = false;
        }
    }

    @Override
    public void addModelListener(ModelListener modelListener) {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.updateBasis = true;
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

