/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evolution.io.Importer;
import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evomodel.arg.ARGModel;
import dr.evomodel.arg.ARGTrace;
import dr.evoxml.util.GraphMLUtils;
import dr.stats.DiscreteStatistics;
import dr.util.FrequencySet;
import dr.util.NumberFormatter;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;

public class ARGTraceAnalysis {
    private int burnin = -1;
    private ARGTrace[] trace;
    private FrequencySet<ARGModel> argSet;

    public ARGTraceAnalysis(ARGTrace[] aRGTraceArray, int n, boolean bl) {
        this.trace = aRGTraceArray;
        int n2 = Integer.MAX_VALUE;
        for (ARGTrace aRGTrace : aRGTraceArray) {
            if (aRGTrace.getMaximumState() >= n2) continue;
            n2 = aRGTrace.getMaximumState();
        }
        if (n < 0 || n >= n2) {
            this.burnin = n2 / (10 * aRGTraceArray[0].getStepSize());
            if (bl) {
                System.out.println("WARNING: Burn-in larger than total number of states - using 10% of smallest trace");
            }
        } else {
            this.burnin = n;
        }
        this.analyze(bl);
    }

    public void analyze(boolean bl) {
        if (bl && this.trace.length > 1) {
            System.out.println("Combining " + this.trace.length + " traces.");
        }
        ARGModel aRGModel = this.getARG(0);
        this.argSet = new FrequencySet();
        this.argSet.add(aRGModel);
        for (ARGTrace aRGTrace : this.trace) {
            int n = aRGTrace.getTreeCount(this.burnin * aRGTrace.getStepSize());
            double d = (double)n / 60.0;
            int n2 = 1;
            if (bl) {
                System.out.println("Analyzing " + n + " ARGs...");
                System.out.println("0              25             50             75            100");
                System.out.println("|--------------|--------------|--------------|--------------|");
                System.out.print("*");
            }
            for (int i = 1; i < n; ++i) {
                aRGModel = aRGTrace.getARG(i, this.burnin * aRGTrace.getStepSize());
                this.argSet.add(aRGModel);
                if (i < (int)Math.round((double)n2 * d) || n2 > 60) continue;
                if (bl) {
                    System.out.print("*");
                    System.out.flush();
                }
                ++n2;
            }
            if (!bl) continue;
            System.out.println("*");
        }
    }

    public final Tree analyzeARG(String string) {
        int n;
        int n2 = this.getTreeCount();
        FlexibleTree flexibleTree = null;
        for (n = 0; n < n2; ++n) {
            ARGModel aRGModel = this.getARG(n);
            if (!TreeUtils.uniqueNewick(aRGModel, aRGModel.getRoot()).equals(string)) continue;
            flexibleTree = new FlexibleTree(aRGModel);
            break;
        }
        if (flexibleTree == null) {
            throw new RuntimeException("No target tree in trace");
        }
        n = flexibleTree.getInternalNodeCount();
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[n2];
            NodeRef nodeRef = flexibleTree.getInternalNode(i);
            Set<String> set = TreeUtils.getDescendantLeaves(flexibleTree, nodeRef);
            for (int j = 0; j < n2; ++j) {
                ARGModel aRGModel = this.getARG(j);
                NodeRef nodeRef2 = TreeUtils.getCommonAncestorNode(aRGModel, set);
                dArray[j] = aRGModel.getNodeHeight(nodeRef2);
            }
            flexibleTree.setNodeHeight(nodeRef, DiscreteStatistics.mean(dArray));
            flexibleTree.setNodeAttribute(nodeRef, "upper", new Double(DiscreteStatistics.quantile(0.975, dArray)));
            flexibleTree.setNodeAttribute(nodeRef, "lower", new Double(DiscreteStatistics.quantile(0.025, dArray)));
        }
        return flexibleTree;
    }

    public final int getTreeCount() {
        int n = 0;
        for (ARGTrace aRGTrace : this.trace) {
            n += aRGTrace.getTreeCount(this.burnin * aRGTrace.getStepSize());
        }
        return n;
    }

    public final ARGModel getARG(int n) {
        int n2 = 0;
        int n3 = 0;
        for (ARGTrace aRGTrace : this.trace) {
            if (n < (n3 += aRGTrace.getTreeCount(this.burnin * aRGTrace.getStepSize()))) {
                return aRGTrace.getARG(n - n2, this.burnin * aRGTrace.getStepSize());
            }
            n2 = n3;
        }
        throw new RuntimeException("Couldn't find ARG " + n);
    }

    public void report() throws IOException {
        int n = 14;
        NumberFormatter numberFormatter = new NumberFormatter(6);
        numberFormatter.setPadding(true);
        numberFormatter.setFieldWidth(n);
        int n2 = this.argSet.size();
        int n3 = this.argSet.getSumFrequency();
        System.out.println();
        System.out.println("burnIn=" + this.burnin);
        System.out.println("total ARGs used =" + n3);
        System.out.println();
        System.out.println("95% credible set (" + n2 + " unique ARGs, " + n3 + " total):");
        System.out.println("Count\tPercent\tARG");
        int n4 = 95 * n3 / 100;
        int n5 = 0;
        NumberFormatter numberFormatter2 = new NumberFormatter(8);
        for (int i = 0; i < n2; ++i) {
            int n6 = this.argSet.getFrequency(i);
            double d = (double)n6 / (double)n3;
            System.out.print(n6);
            System.out.print("\t" + numberFormatter2.formatDecimal(d * 100.0, 2) + "%");
            double d2 = (double)(n5 += n6) / (double)n3;
            System.out.print("\t" + numberFormatter2.formatDecimal(d2 * 100.0, 2) + "%");
            String string = this.argSet.get(i).toString();
            System.out.println("\t" + string);
            if (n5 < n4) continue;
            System.out.println();
            System.out.println("95% credible set has " + (i + 1) + " ARGs.");
            break;
        }
        System.out.println();
        System.out.println("DOT Format for most probable ARG:");
        System.out.println(GraphMLUtils.dotFormat(this.argSet.get(0).toXML()));
        System.out.flush();
    }

    public void shortReport(String string, Tree tree, boolean bl) throws IOException {
    }

    public int getBurnin() {
        return this.burnin;
    }

    public static ARGTraceAnalysis analyzeLogFile(Reader[] readerArray, int n, boolean bl) throws IOException {
        ARGTrace[] aRGTraceArray = new ARGTrace[readerArray.length];
        for (int i = 0; i < readerArray.length; ++i) {
            try {
                aRGTraceArray[i] = ARGTrace.loadARGTrace(readerArray[i]);
            }
            catch (Importer.ImportException importException) {
                throw new RuntimeException(importException.toString());
            }
            readerArray[i].close();
        }
        return new ARGTraceAnalysis(aRGTraceArray, n, bl);
    }
}

