/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptableVarianceMultivariateNormalOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleOperatorSchedule;
import java.util.ArrayList;
import java.util.List;

public class TwoPhaseOperator
extends AbstractAdaptableOperator {
    public static final boolean DEBUG = false;
    public static final boolean PROVIDE_SAMPLES = false;
    private List<AbstractAdaptableOperator> phaseOneOperators;
    private List<AdaptableVarianceMultivariateNormalOperator> phaseTwoOperators;
    private List<AbstractAdaptableOperator> currentOperators;
    private SimpleOperatorSchedule phaseOneScheduler;
    private SimpleOperatorSchedule phaseTwoScheduler;
    private SimpleOperatorSchedule currentOperatorScheduler;
    private List<Parameter> parameters;
    private ArrayList<ArrayList<Double>> storedValues;
    private int initial;
    private int burnin;
    private int numberOfCalls;
    private int currentOperatorIndex;
    private boolean switchOperators;

    public TwoPhaseOperator(List<AbstractAdaptableOperator> list, List<AdaptableVarianceMultivariateNormalOperator> list2, List<Parameter> list3, int n, int n2, double d, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.setWeight(d);
        this.initial = n;
        this.burnin = n2;
        this.numberOfCalls = 0;
        this.switchOperators = false;
        this.phaseOneOperators = list;
        this.phaseTwoOperators = list2;
        this.parameters = list3;
        this.storedValues = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            this.storedValues.add(new ArrayList());
        }
        this.phaseOneScheduler = new SimpleOperatorSchedule();
        for (MCMCOperator mCMCOperator : list) {
            this.phaseOneScheduler.addOperator(mCMCOperator);
        }
        this.phaseTwoScheduler = new SimpleOperatorSchedule();
        for (MCMCOperator mCMCOperator : list2) {
            this.phaseTwoScheduler.addOperator(mCMCOperator);
        }
        this.currentOperatorScheduler = this.phaseOneScheduler;
        this.currentOperators = list;
    }

    @Override
    public double doOperation() {
        ++this.numberOfCalls;
        this.currentOperatorIndex = this.currentOperatorScheduler.getNextOperatorIndex();
        if (this.numberOfCalls > this.burnin && !this.switchOperators) {
            int n = 0;
            int n2 = this.currentOperatorIndex;
            for (int i = 0; i < this.phaseTwoOperators.size() && this.currentOperatorIndex >= this.phaseTwoOperators.get(i).getParameter().getSize(); ++i) {
                n2 -= this.phaseTwoOperators.get(i).getParameter().getSize();
                ++n;
            }
            this.storedValues.get(this.currentOperatorIndex).add(this.parameters.get(n).getParameterValue(n2));
        }
        if (this.numberOfCalls > this.initial && !this.switchOperators) {
            this.currentOperatorScheduler = this.phaseTwoScheduler;
            this.currentOperators = this.phaseTwoOperators;
            this.currentOperatorIndex = this.currentOperatorScheduler.getNextOperatorIndex();
            this.switchOperators = true;
        }
        double d = this.currentOperators.get(this.currentOperatorIndex).doOperation();
        return d;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return this.currentOperators.get(this.currentOperatorIndex).getAdaptableParameter();
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.currentOperators.get(this.currentOperatorIndex).setAdaptableParameterValue(d);
    }

    @Override
    public double getRawParameter() {
        return this.currentOperators.get(this.currentOperatorIndex).getRawParameter();
    }

    @Override
    public String getAdaptableParameterName() {
        return "windowSize";
    }

    @Override
    public String getOperatorName() {
        return "twoPhaseOperator(use at own risk)";
    }
}

