/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.mcmc;

import dr.inference.markovchain.Acceptor;
import dr.math.MathUtils;

public class MCMCCriterion
implements Acceptor {
    protected double temperature = 1.0;

    public MCMCCriterion() {
        this.temperature = 1.0;
    }

    public MCMCCriterion(double d) {
        this.temperature = d;
    }

    public double getAcceptanceValue(double d, double d2) {
        double d3 = (MathUtils.randomLogDouble() + d * this.temperature - d2) / this.temperature;
        return d3;
    }

    @Override
    public boolean accept(double d, double d2, double d3, double[] dArray) {
        double d4;
        dArray[0] = (d2 - d) * this.temperature + d3;
        if (dArray[0] > 0.0) {
            dArray[0] = 0.0;
        }
        boolean bl = (d4 = MathUtils.randomLogDouble()) < dArray[0];
        return bl;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double d) {
        this.temperature = d;
    }
}

