/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.UniformDistribution;

public class UniformDistributionModel
extends AbstractModel
implements ParametricDistributionModel {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return 1.0;
        }

        @Override
        public final double getLowerBound() {
            return UniformDistributionModel.this.getLower();
        }

        @Override
        public final double getUpperBound() {
            return UniformDistributionModel.this.getUpper();
        }
    };
    private final Parameter lowerParameter;
    private final Parameter upperParameter;

    public UniformDistributionModel(Parameter parameter, Parameter parameter2) {
        super("uniformDistributionModel");
        this.lowerParameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.upperParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
    }

    public double getLower() {
        return this.lowerParameter.getParameterValue(0);
    }

    public double getUpper() {
        return this.upperParameter.getParameterValue(0);
    }

    @Override
    public double pdf(double d) {
        return UniformDistribution.pdf(d, this.getLower(), this.getUpper());
    }

    @Override
    public double logPdf(double d) {
        return UniformDistribution.logPdf(d, this.getLower(), this.getUpper());
    }

    @Override
    public double cdf(double d) {
        return UniformDistribution.cdf(d, this.getLower(), this.getUpper());
    }

    @Override
    public double quantile(double d) {
        return UniformDistribution.quantile(d, this.getLower(), this.getUpper());
    }

    @Override
    public double mean() {
        return UniformDistribution.mean(this.getLower(), this.getUpper());
    }

    @Override
    public double variance() {
        return UniformDistribution.variance(this.getLower(), this.getUpper());
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

