/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.Patterns;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class MergePatternsParser
extends AbstractXMLObjectParser {
    public static final String MERGE_PATTERNS = "mergePatterns";
    public static final String UNIQUE = "unique";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(PatternList.class, 1, Integer.MAX_VALUE)};

    @Override
    public String getParserName() {
        return MERGE_PATTERNS;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        int n;
        boolean bl = xMLObject.getAttribute(UNIQUE, true);
        PatternList patternList = (PatternList)xMLObject.getChild(0);
        Patterns patterns = new Patterns(patternList, bl);
        if (bl) {
            for (n = 1; n < xMLObject.getChildCount(); ++n) {
                patterns.addPatterns((PatternList)xMLObject.getChild(n));
            }
        } else {
            for (n = 1; n < xMLObject.getChildCount(); ++n) {
                patterns.appendPatterns((PatternList)xMLObject.getChild(n));
            }
        }
        if (xMLObject.hasAttribute("id")) {
            Logger logger = Logger.getLogger("dr.evoxml");
            logger.info("Site patterns '" + xMLObject.getId() + "' created by merging " + xMLObject.getChildCount() + " pattern lists");
            logger.info("  pattern count = " + patterns.getPatternCount());
        }
        return patterns;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "A weighted list of the site patterns (columns) in an alignment.";
    }

    @Override
    public Class getReturnType() {
        return PatternList.class;
    }
}

