% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal-distributions.R
\name{as_marginal_inference}
\alias{as_marginal_inference}
\title{Model-average marginal posterior distributions and
marginal Bayes factors based on BayesTools JAGS model via \code{marginal_inference}}
\usage{
as_marginal_inference(
  model,
  marginal_parameters,
  parameters,
  conditional_list,
  conditional_rule,
  formula,
  null_hypothesis = 0,
  normal_approximation = FALSE,
  n_samples = 10000,
  silent = FALSE,
  force_plots = FALSE
)
}
\arguments{
\item{model}{model fit via the \link{JAGS_fit} function}

\item{marginal_parameters}{parameters for which the the marginal summary
should be created}

\item{parameters}{all parameters included in the model_list that are
relevant for the formula (all of which need to have specification of
\code{is_null_list})}

\item{conditional_list}{list of conditional parameters for each marginal parameter}

\item{conditional_rule}{a character string specifying the rule for conditioning.
Either "AND" or "OR". Defaults to "AND".}

\item{formula}{model formula (needs to be specified if \code{parameter} was part of a formula)}

\item{null_hypothesis}{point null hypothesis to test. Defaults to \code{0}}

\item{normal_approximation}{whether the height of prior and posterior density should be
approximated via a normal distribution (rather than kernel density). Defaults to \code{FALSE}.}

\item{n_samples}{number of samples to be drawn for the model-averaged
prior distribution}

\item{silent}{whether warnings should be returned silently. Defaults to \code{FALSE}}

\item{force_plots}{temporal argument allowing to generate conditional posterior samples
suitable for prior and posterior plots. Only available when conditioning on a
single parameter.}
}
\value{
\code{as_marginal_inference} returns an object of class 'marginal_inference'.
}
\description{
Creates marginal model-averaged and conditional
posterior distributions based on a BayesTools JAGS model, vector of parameters,
formula, and a list of conditional specifications for each parameter.
Computes inclusion Bayes factors for each marginal estimate via a Savage-Dickey
density approximation.
}
\seealso{
\link{marginal_inference} \link{as_mixed_posteriors}
}
