% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_convergence.R
\name{assess_convergence}
\alias{assess_convergence}
\title{Trace Plots from Metropolis-Hastings Algorithm}
\usage{
assess_convergence(model_fit, type = "alpha", items = NULL,
  assessors = NULL)
}
\arguments{
\item{model_fit}{A fitted model object of class \code{BayesMallows}, obtained
with \code{\link{compute_mallows}}.}

\item{type}{Character string specifying which plot type we want. Available
options are \code{"alpha"}, \code{"rho"}, \code{"Rtilde"}, or
\code{"cluster_probs"}.}

\item{items}{The items to study in the diagnostic plot for \code{rho}. Either
a vector of item names, corresponding to \code{model_fit$items} or a
vector of indices. If NULL, five items are selected randomly. Only used when \code{type = "rho"}.}

\item{assessors}{Numeric vector specifying the assessors to study in
the diagnostic plot for \code{"Rtilde"}.}
}
\description{
\code{assess_convergence} provides trace plots for the parameters of the
Mallows Rank model, in order to study the convergence of the Metropolis-Hastings
algorithm.
}
\seealso{
\code{\link{compute_mallows}}, \code{\link{plot.BayesMallows}}
}
