% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mra-wendland-2d-pred.R
\name{mra_wendland_2d_pred}
\alias{mra_wendland_2d_pred}
\title{Code to construct the mutli-resolution sparse basis function representation for fitting spatial processes}
\usage{
mra_wendland_2d_pred(locs, locs_pred, MRA, use_spam = TRUE)
}
\arguments{
\item{locs}{The location variables in 2 dimensions over which to construct the basis function representation in the fitting stage.}

\item{locs_pred}{The location variables in 2 dimensions over which to construct the basis function representation in the prediction stage.}

\item{MRA}{The multi-resolution basis expansion at the observed locations. This object is the output of \verb{mra_wendland-2d()} and is of class "mra_wendland_2d".}

\item{use_spam}{is a boolean flag to determine whether the output is a list of spam matrix objects (\code{use_spam = TRUE}) or a an \eqn{n \times n}{n x n} sparse Matrix of class "dgCMatrix" \code{use_spam = FALSE} (see spam and Matrix packages for details).}
}
\value{
A list of objects including the MRA knots locations \code{locs_grid},
the Wendland basis representation matrix \code{W_pred} at the prediction locations, and the basis radius \code{radius}
}
\description{
Code to construct the mutli-resolution sparse basis function representation for fitting spatial processes
}
\examples{
set.seed(111)
locs <- matrix(runif(20), 10, 2)
locs_pred <- matrix(runif(20), 10, 2)
MRA <- mra_wendland_2d(locs, M = 2, n_coarse_grid = 4)
MRA_pred <- mra_wendland_2d_pred(locs, locs_pred, MRA)

## plot the MRA prediction grid at different resolutions
layout(matrix(1:2, 1, 2))
plot(MRA_pred$locs_grid[[1]])
plot(MRA_pred$locs_grid[[2]])

}
