% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastGPfit.R
\name{GP.std.grids}
\alias{GP.std.grids}
\title{Compute the standardized grids}
\usage{
GP.std.grids(
  grids,
  center = apply(grids, 2, mean),
  scale = NULL,
  max_range = 6
)
}
\arguments{
\item{grids}{A matrix where rows represent grid points and columns are coordinates.}

\item{center}{A vector of real numbers specifying the centroid parameters in the modified exponential squared kernel. The default value is NULL and set to the center of the grid points: apply(x,2,mean).}

\item{scale}{A vector of positive numbers specifying the scale parameters in the modified exponential squared kernel. The default value is NULL and set to values such that grid points in a range of (-max_range,max_range) in each dimension.}

\item{max_range}{A positive real number indicating the maximum range of the grid points to specify the scale parameter. The default value is NULL and set to 6.}
}
\value{
A matrix where rows represent the standardized grids.
}
\description{
Compute the standardized grids
}
\examples{
library(BayesGPfit)
grids = GP.generate.grids(d=2L)
std_grids = GP.std.grids(grids)
plot(grids[,1],std_grids[,1],asp=1,type="l")
abline(a=0,b=1,lty=2)
}
\author{
Jian Kang <jiankang@umich.edu>
}
