




<!-- NEWS.md was auto-generated by NEWS.Rmd. Please DO NOT edit by hand!-->

## BayLum 0.2.1 (2022-02-20)

*Note: This package version needs at least R \>= 4.0.*

### Bugfixes & changes

#### `AgeS_Computation()`

-   The function crashed if `jags_method = "rjparallel"` with a runtime
    error due to missing information about the RNG type; fixed (thanks
    to @IMHarly for spotting).
-   If `jags_method = "rjparallel"` the inits were preset to a specific
    value for the random number generator. While this setting led to a
    crash of the function and probably caused no harm, the setting did
    not make any sense. Now, the random number generator settings (seed,
    type etc.) can be provided via the argument `inits`, which is passed
    to `runjags::autorun.jags`. The default is `NA` to maintain the
    expected behaviour if `jags_method = "rjparallel"` is used.
-   The function gained a new argument `model` to inject custom models
    to run with the parameters as already defined for the model. This
    option allows to adjust priors and likelihoods to test different
    scenarios. Please not that this option works without a safety net,
    mean the function does not check whether the parameters in the model
    are actually available.
-   The function now returns the used model as a character string, in
    combination with the new parameter `model` it can be used to modify
    the model on the fly.

#### `Age_OSLC14()`

-   Add support for `"rjparallel"` via new argument
    `jags_method = "rjparallel"`, like in `AgeS_Computation()` (thanks
    @IMHarly, \#20).

#### `Generate_DataFile_MG()`

-   The function gained a new argument `force_run1_at_a_time`. If set to
    `TRUE` it automatically orders the curves in the BIN/BINX-file
    following the “Run 1 at a time” option. Regardless of whether this
    option was used for the measurement or not. Please note: this cannot
    work if you have assigned a position number more than one time to
    different aliquots.
-   `verbose = FALSE` was not respected under all circumstances; fixed.

## BayLum 0.2.0 (2020-12-06)

*Note: This package version needs at least R \>= 3.5.0.*

### Bugfixes & changes

-   `AgeS_Computation()`
    -   Now stops if a mismatch was encountered between the number of
        samples and the matrix provided via `THETA` to prevent a ‘JAGS’
        runtime error
    -   The function experimentally gained a new argument `jags_method`
        to support full automated processing in parallel using the R
        package `'runjags'`; including a `...` argument for a more
        detailed control. By default the calculation is done simply via
        `'rjags'` as usual
-   `Age_OSLC14()`
    -   Add additional output to enhance output table by additional
        information (#11)
    -   The CSV-file option now returns the age and the HPD intervals
    -   The bugs model for the `gaussian` distribution did not work due
        to a wrongly set index (#13); fixed.
    -   If a small number of samples was used and the first was a C-14
        sample JAGS crashed; now it throws are more comprehensible error
        message (#14).
-   `Generate_DataFile_MG()`
    -   now works only on preselected records; the limitation of OSL
        only was removed.
-   `plot_Ages()`
    -   The sorting of the samples in the graph did not work as
        expected; along with this a new argument `sample_order` was
        added.
    -   The function accepts a data.frame as alternative input, if the
        `data.frame` is similar the data frames created by the
        computation functions (e.g., `AgeS_Computation()`). This option
        enables the manual creation of age plots from self-compiled
        data.
-   `plot_MCMC()`
    -   Accidentally the function could not display the chains from more
        than 9 samples; fixed (thanks to Maryam Heydari)
    -   Now the function understand the output of `AgeS_Computation()`
        for an automated treatment
    -   Wrong variable names now lead to a `warning` instead of a
        `stop`. This is less aggressive and it makes the function easier
        to use by users who only use the plot functionality of
        `'BayLum'`
-   `plot_Scatterplots()`
    -   Line breaks and leading and trailing white space is now removed
        from the character (vector) provided via `sample_names`
    -   If the number of selected samples via `sample_selection` was
        shorter than the number of names provided by `sample_names` the
        function returned an `subscript out of bounds` error; fixed
        (reported by Maryam Heydari)

#### Internals

-   All models now come with an example showing how they can be
    inspected (before the examples not working)
-   Fix a couple of documentation glitches (e.g., part of the
    documentation was missing)
-   Smooth the creation of `BayLum.list` objects using a central
    internal function
-   Add new C-14 calibration data and unify the names of those datasets.
    Allowed inputs are
    `"IntCal13"`,`"IntCal20"`,`"Marine13"`,`"Marine20"`, `"SHCal13"`,
    `"SHCal20"` or an own dataset which must be stored in a CSV-file.

### New functions

-   `create_ThetaMatrix()` this function is a helper to create the theta
    matrix that can be provided as input for the functions
    `AgeS_Computation()` and `Age_OSLC14()`
-   `create_FolderTemplates()` creates the folder and file structures
    required by `Generate_DataFile()` and `Generate_DataFile_MG()` on
    the user’s hard drive

## BayLum 0.1.3 (Release date: 2018-09-14)

### New functions

-   `plot_Ages()` this function replaces code used internally by the
    functions `AgeC14_Compution()` and `AgeS_Computation()` to create an
    age overview plot. Before the user had no control over the
    appearance of age plot output. This is still the case if the
    functions `AgeC14_Compution()`, `AgeS_Computation()` and
    `Age_OSLC14()` are used (although internally only the function
    `plot_Ages()` is called), however, both functions now return a new
    list of class `BayLum.list` which is recognised by the function
    `plot_Ages()` and can be used to plot the typical age plot while
    providing several arguments for adjusting the plot output.

### Bugfixes & changes

-   The newly introduced function `combine_DataFiles()` did not work on
    R \< 3.5.0, which caused an error on CRAN; fixed.
-   The function `ScatterSamples()` is replaced by the function
    `plot_Scatterplots()`
-   All computation functions left text connections open after they have
    been exited; fixed.
-   The output of `AgeC14_Compution()` and `AgeS_Computation()` gain a
    new class `BayLum.list`
-   Redundant code in `AgeC14_Compution()` and `AgeS_Computation()` has
    been removed
-   The argument `Nb_chaines` was replaced by `n.chains` wherever it
    occurred in the package (functions and documentation)
-   The function `plot_Scatterplots()` gained a new argument
    `plot_type`, allowing to switch between the default hexbin plot and
    a function developed for ’BayLum`(`plot_type = “smoothScatter”\`)
-   The function `plot_Scatterplots()` gained a new argument `plot_mode`
    to allow single xy plots
-   The function `plot_Scatterplots()` now accepts a two column
    `data.frame` as inputbuild

### Internals

-   Add new package dependency `KernSmooth` used in
    `plot_Scatterplots()`

## BayLum 0.1.2 (Release date: 2018-06-22)

### New functions

-   The function `MCMC_plot()` was replaced by the newly written
    function `plot_MCMC()`
-   The function `Concat_DataFile()` is deprecated and is basically
    replaced by the function `combine_DataFiles()`

### Bugfixes

-   The functions `AgeC14_Compution()` and `Age_OSL14()` now returns age
    results with two digits
-   The function `AgeS_Computation()` now returns the MCMC information
    from all samples of the PDF output is set to `TRUE`
-   The function `Age_OSLC14()` never returned numerical data; fixed
-   Fix `Age_OSLC14()` age format, now in ka for C-14 instead of years
-   The last example in `AgeS_Computation()` could not be run; fixed
-   C-14 calibration datasets now show data in ‘ka’ and not ‘a’
-   Various typo corrections.

### Enhancements

-   Allow different BIN/BINX-file names as input. The functions
    `Generate_DataFile()` and `Generate_DataFile_MG()` do no longer
    expecting the name sheme bin.BIN
-   The functions `Generate_DataFile()` and `Generate_DataFile_MG()` now
    supports the `...` argument to pass further arguments to the
    function `Luminescene::read_BIN2R()`
-   The functions `Generate_DataFile()` and `Generate_DataFile_MG()`
    gained a new argument `verbose` to control the terminal output
-   The function
    `Age_Computation()`,`AgeS_Computation()`,`AgeC14_Computation()`,
    `Age_OSLC14()` now support the argument `quiet` and pipe it to
    `rjags` to suppress the terminal output
-   The function `AgeC14_Computation()` now returns a warning if
    outliers are detected.
-   The function `LT_RegenDose()` gained two new arguments `nrow` and
    `ncol` became a little bit more user friendly

### Internals

-   Set patch level to 0 (for 3.3.0) to account for CRAN note
-   Vignette was updated and corrected

## BayLum 0.1.1 (Release date: 2017-09-01)

-   Reduce required R version to 3.3.2

## BayLum 0.1.0 (Release date: 2017-08-22)

-   Initial version on CRAN
