% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/rename.R
\name{rename_elements}
\alias{rename_elements}
\alias{rename_elements,TidySet-method}
\title{Rename elements}
\usage{
rename_elements(object, old, new)

\S4method{rename_elements}{TidySet}(object, old, new)
}
\arguments{
\item{object}{A TidySet object.}

\item{old}{A character vector of to be renamed.}

\item{new}{A character vector of with new names.}
}
\value{
A \code{TidySet} object.
}
\description{
Change the default names of sets and elements.
}
\section{Methods (by class)}{
\itemize{
\item \code{rename_elements(TidySet)}: Rename elements

}}
\examples{
x <- list("A" = letters[1:5], "B" = letters[3:7])
TS <- tidySet(x)
name_elements(TS)
TS2 <- rename_elements(TS, "a", "first")
name_elements(TS2)
}
\seealso{
\code{\link[=name_elements]{name_elements()}}

Other renames: 
\code{\link{rename_set}()}

Other names: 
\code{\link{name_elements<-}()},
\code{\link{name_elements}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{rename_set}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
\concept{names}
\concept{renames}
