% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/relations.R
\name{relations}
\alias{relations}
\alias{relations<-}
\alias{relations,TidySet-method}
\alias{replace_relations}
\alias{relations<-,TidySet-method}
\alias{nRelations,TidySet-method}
\title{Relations of the TidySet}
\usage{
relations(object)

relations(object) <- value

\S4method{relations}{TidySet}(object)

replace_relations(object, value)

\S4method{relations}{TidySet}(object) <- value

\S4method{nRelations}{TidySet}(object)
}
\arguments{
\item{object}{Object to be coerced or tested.}

\item{value}{Modification of the relations.}
}
\value{
A \code{data.frame} with information about the relations between
elements and sets.
}
\description{
Given TidySet retrieve the relations or substitute them.
\code{\link[=TidySet]{TidySet()}} object
}
\section{Methods (by class)}{
\itemize{
\item \code{relations(TidySet)}: Retrieve the relations

\item \code{relations(TidySet) <- value}: Modify the relations

\item \code{nRelations(TidySet)}: Return the number of unique relations

}}
\examples{
TS <- tidySet(list(A = letters[1:2], B = letters[5:7]))
relations(TS)
}
\seealso{
\code{\link[=nRelations]{nRelations()}}

Other slots: 
\code{\link{elements}()},
\code{\link{sets}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
\concept{slots}
